/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.design.analysis;

import com.google.common.collect.Ordering;
import com.google.common.primitives.Doubles;
import edu.duke.cs.osprey.confspace.ConfSearch;
import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.Collectors;

public class EnergiedConfQueue {
    private final int numElements;
    private Ordering<ConfSearch.EnergiedConf> lowestEnergyFirstOrdering = new Ordering<ConfSearch.EnergiedConf>(this){

        public int compare(ConfSearch.EnergiedConf left, ConfSearch.EnergiedConf right) {
            return Doubles.compare((double)left.getEnergy(), (double)right.getEnergy());
        }
    };
    private final PriorityQueue<ConfSearch.EnergiedConf> confQueue = new PriorityQueue(this.lowestEnergyFirstOrdering.reverse());

    public EnergiedConfQueue(int maxElements) {
        this.numElements = maxElements;
    }

    public List<ConfSearch.EnergiedConf> toOrderedList() {
        return this.confQueue.stream().sorted(this.lowestEnergyFirstOrdering).collect(Collectors.toList());
    }

    public void add(ConfSearch.EnergiedConf conf) {
        if (this.confQueue.size() < this.numElements) {
            this.confQueue.add(conf);
            return;
        }
        assert (this.confQueue.size() > 0);
        ConfSearch.EnergiedConf maxConf = this.confQueue.peek();
        if (conf.getEnergy() < maxConf.getEnergy()) {
            this.confQueue.poll();
            this.confQueue.add(conf);
        }
    }
}

