/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.control;

import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.confspace.PositionConfSpace;
import edu.duke.cs.osprey.confspace.RC;
import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.control.ConfigFileParser;
import edu.duke.cs.osprey.minimization.CCDMinimizer;
import edu.duke.cs.osprey.minimization.MoleculeModifierAndScorer;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;
import edu.duke.cs.osprey.restypes.HardCodedResidueInfo;
import edu.duke.cs.osprey.structure.Residue;

public class EnergyCalculator {
    public void run(ConfigFileParser cfp) {
        double energy;
        SearchProblem search2 = cfp.getSearchProblem();
        System.out.println();
        if (cfp.params.getBool("doPerturbations")) {
            throw new Error("DEEPer not supported by Energy Calculator");
        }
        if (!cfp.params.getBool("addWTRots")) {
            throw new Error("Must turn on addWTRots to use Energy Calculator. Otherwise, you're just evaluating arbitrary conformations");
        }
        System.out.println("Setting wild-type rotamers...");
        for (int i = 0; i < search2.confSpace.numPos; ++i) {
            PositionConfSpace pos = search2.confSpace.posFlex.get(i);
            if (pos.wtRCs.size() > 1) {
                System.out.println(String.format("WARNING: %d wild-type rotamers found for residue at design index %d. Picking first one aribtrarily", pos.wtRCs.size(), pos.designIndex));
            }
            RC rc = pos.wtRCs.get(0);
            Residue res = search2.confSpace.m.getResByPDBResNumber(search2.confSpace.flexibleRes.get(i));
            if (!HardCodedResidueInfo.hasAminoAcidBB(res) || res.fullName.startsWith("FOL")) continue;
            search2.confSpace.mutDOFs.get(i).switchToTemplate(rc.template);
        }
        if (cfp.params.getBool("doMinimize")) {
            System.out.println("Building energy function...");
            MoleculeModifierAndScorer objFunc = new MoleculeModifierAndScorer(search2.fullConfE, search2.confSpace);
            System.out.println(String.format("Minimizing %d degrees of freedom...", objFunc.getNumDOFs()));
            DoubleMatrix1D optDOFVals = new CCDMinimizer((ObjectiveFunction)objFunc, (boolean)false).minimize().dofValues;
            System.out.println("Calculating energy...");
            energy = objFunc.getValue(optDOFVals);
        } else {
            System.out.println("Calculating energy...");
            energy = search2.fullConfE.getEnergy();
        }
        System.out.println(String.format("Energy: %f kcal/mol\n", energy));
    }
}

