/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace.compiled;

import edu.duke.cs.osprey.confspace.compiled.ConfSpace;
import edu.duke.cs.osprey.confspace.compiled.ContinuousMotion;
import edu.duke.cs.osprey.confspace.compiled.CoordsList;
import edu.duke.cs.osprey.confspace.compiled.DegreeOfFreedom;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.joml.Vector3d;

public class AssignedCoords {
    public final ConfSpace confSpace;
    public final int[] assignments;
    public final CoordsList coords;
    public final List<DegreeOfFreedom> dofs = new ArrayList<DegreeOfFreedom>();

    public AssignedCoords(ConfSpace confSpace, int[] assignments) {
        this.confSpace = confSpace;
        this.assignments = assignments;
        this.coords = new CoordsList(confSpace.maxNumConfAtoms);
    }

    public void copyCoords() {
        this.coords.copyFrom(this.confSpace.staticCoords, 0);
        for (ConfSpace.Pos pos : this.confSpace.positions) {
            int confi = this.assignments[pos.index];
            if (confi == ConfSpace.NotAssigned) continue;
            ConfSpace.Conf conf = pos.confs[confi];
            this.coords.copyFrom(conf.coords, this.confSpace.confAtomOffsetsByPos[pos.index]);
        }
    }

    public void makeDofs() {
        this.dofs.clear();
        for (int moli = 0; moli < this.confSpace.molInfos.length; ++moli) {
            ConfSpace.MolInfo molInfo = this.confSpace.molInfos[moli];
            for (int i = 0; i < molInfo.motions.length; ++i) {
                ContinuousMotion motion = molInfo.motions[i].build(this, moli);
                motion.appendDofs(this.dofs);
            }
        }
        for (ConfSpace.Pos pos : this.confSpace.positions) {
            int confi = this.assignments[pos.index];
            if (confi == ConfSpace.NotAssigned) continue;
            ConfSpace.Conf conf = pos.confs[confi];
            for (int i = 0; i < conf.motions.length; ++i) {
                ContinuousMotion motion = conf.motions[i].build(this, pos);
                motion.appendDofs(this.dofs);
            }
        }
        assert (this.dofs.size() <= this.confSpace.maxNumDofs);
    }

    public double getStaticEnergy(int ffi) {
        return this.confSpace.staticEnergies[ffi];
    }

    public double getInternalEnergy(int ffi, int posi) {
        int confi = this.assignments[posi];
        if (confi == ConfSpace.NotAssigned) {
            return 0.0;
        }
        return this.confSpace.positions[posi].confs[confi].energies[ffi];
    }

    public ConfSpace.IndicesStatic getIndices(int ffi) {
        return this.confSpace.indicesStatic(ffi);
    }

    public ConfSpace.IndicesSingle getIndices(int ffi, int posi) {
        int confi = this.assignments[posi];
        if (confi == ConfSpace.NotAssigned) {
            return null;
        }
        return this.confSpace.indicesSingles(ffi, posi, confi);
    }

    public ConfSpace.IndicesPair getIndices(int ffi, int posi1, int posi2) {
        int confi1 = this.assignments[posi1];
        int confi2 = this.assignments[posi2];
        if (confi1 == ConfSpace.NotAssigned || confi2 == ConfSpace.NotAssigned) {
            return null;
        }
        return this.confSpace.indicesPairs(ffi, posi1, confi1, posi2, confi2);
    }

    public double[] getParams(int ffi, int paramsi) {
        return this.confSpace.ffparams(ffi, paramsi);
    }

    public int getStaticIndex(int atomi) {
        return this.confSpace.getStaticAtomIndex(atomi);
    }

    public int getConfIndex(int posi, int atomi) {
        return this.confSpace.getConfAtomIndex(posi, atomi);
    }

    public Molecule toMol() {
        Function<Integer, String> makeResKey = resInfoIndex -> {
            ConfSpace.ResInfo resInfo = this.confSpace.resInfos[resInfoIndex];
            return String.format("%s%s", resInfo.chainId, resInfo.resId);
        };
        HashMap<String, Integer> staticResInfos = new HashMap<String, Integer>();
        for (int i = 0; i < this.confSpace.numStaticAtoms; ++i) {
            int resInfoIndex2 = this.confSpace.staticResInfoIndices[i];
            if (resInfoIndex2 == ConfSpace.NoResidue) continue;
            staticResInfos.put(makeResKey.apply(resInfoIndex2), resInfoIndex2);
        }
        HashMap<String, Integer> assignedResInfos = new HashMap<String, Integer>();
        HashMap<Integer, String> assignedResTypes = new HashMap<Integer, String>();
        for (int posi = 0; posi < this.confSpace.numPos(); ++posi) {
            int confi = this.assignments[posi];
            if (confi == -1) continue;
            ConfSpace.Conf conf = this.confSpace.positions[posi].confs[confi];
            for (int atomi = 0; atomi < conf.numAtoms; ++atomi) {
                int resInfoIndex3 = conf.atomResInfoIndices[atomi];
                String resKey = makeResKey.apply(resInfoIndex3);
                Integer oldResInfoIndex = (Integer)assignedResInfos.get(resKey);
                if (oldResInfoIndex != null && oldResInfoIndex != resInfoIndex3) {
                    throw new IllegalArgumentException("Multiple assigments conflict at residue " + resKey + ", including position " + this.confSpace.positions[posi].name + ". Can't pick unique residue type for residue-centric molecule formats, like PDB. Probably caused by multiple design positions affecting the same residue.");
                }
                assignedResInfos.put(resKey, resInfoIndex3);
                assignedResTypes.put(resInfoIndex3, conf.type);
            }
        }
        HashMap<String, Integer> resInfoIndexMap = new HashMap<String, Integer>();
        resInfoIndexMap.putAll(staticResInfos);
        resInfoIndexMap.putAll(assignedResInfos);
        LinkedHashMap<Integer, Map> residuedAtomInfos = new LinkedHashMap<Integer, Map>();
        LinkedHashMap<Integer, List> molAtomInfos = new LinkedHashMap<Integer, List>();
        class AtomInfo {
            final Vector3d pos = new Vector3d();
            public String name;
            int molInfoIndex;
            int resInfoIndex;

            AtomInfo(AssignedCoords this$0) {
            }
        }
        Consumer<AtomInfo> addInfo = info2 -> {
            if (info2.resInfoIndex >= 0) {
                residuedAtomInfos.computeIfAbsent(info2.molInfoIndex, index -> new LinkedHashMap()).computeIfAbsent(this.confSpace.resInfos[info2.resInfoIndex].chainId, id -> new LinkedHashMap()).computeIfAbsent(info2.resInfoIndex, index -> new ArrayList()).add(info2);
            } else {
                molAtomInfos.computeIfAbsent(info2.molInfoIndex, index -> new ArrayList()).add(info2);
            }
        };
        for (int posi = 0; posi < this.confSpace.numPos(); ++posi) {
            int confi = this.assignments[posi];
            if (confi == -1) continue;
            ConfSpace.Conf conf = this.confSpace.positions[posi].confs[confi];
            for (int atomi = 0; atomi < conf.numAtoms; ++atomi) {
                AtomInfo atomInfo = new AtomInfo(this);
                this.coords.get(this.getConfIndex(posi, atomi), atomInfo.pos);
                atomInfo.name = conf.atomNames[atomi];
                atomInfo.molInfoIndex = conf.atomMolInfoIndices[atomi];
                atomInfo.resInfoIndex = conf.atomResInfoIndices[atomi];
                if (atomInfo.resInfoIndex != (Integer)resInfoIndexMap.get(makeResKey.apply(atomInfo.resInfoIndex))) {
                    throw new Error("residue assignments from conf atoms don't match previously-determined residue assignments... from the conf atoms. Obviously this is a bug");
                }
                addInfo.accept(atomInfo);
            }
        }
        for (int i = 0; i < this.confSpace.numStaticAtoms; ++i) {
            AtomInfo atomInfo = new AtomInfo(this);
            this.coords.get(this.getStaticIndex(i), atomInfo.pos);
            atomInfo.name = this.confSpace.staticNames[i];
            atomInfo.molInfoIndex = this.confSpace.staticMolInfoIndices[i];
            atomInfo.resInfoIndex = this.confSpace.staticResInfoIndices[i];
            if (atomInfo.resInfoIndex != ConfSpace.NoResidue) {
                atomInfo.resInfoIndex = (Integer)resInfoIndexMap.get(makeResKey.apply(atomInfo.resInfoIndex));
            }
            addInfo.accept(atomInfo);
        }
        Molecule mol = new Molecule();
        HashSet usedChainIds = new HashSet();
        Supplier<String> makeChainId = () -> {
            for (char id = 'A'; id <= 'Z'; id = (char)(id + '\u0001')) {
                String str = Character.toString(id);
                if (usedChainIds.contains(str)) continue;
                usedChainIds.add(str);
                return str;
            }
            throw new NoSuchElementException("can't find unused chain id");
        };
        HashSet usedResIds = new HashSet();
        Supplier<String> makeResId = () -> {
            for (int id = 1; id < 9999; ++id) {
                String str = Integer.toString(id);
                if (usedResIds.contains(str)) continue;
                usedResIds.add(str);
                return str;
            }
            throw new NoSuchElementException("can't find unused chain id");
        };
        BiConsumer<String, List> makeRes = (name, atomInfos) -> {
            ArrayList<Atom> atoms = new ArrayList<Atom>();
            double[] coords = new double[atomInfos.size() * 3];
            for (int i = 0; i < atomInfos.size(); ++i) {
                AtomInfo atomInfo = (AtomInfo)atomInfos.get(i);
                atoms.add(new Atom(atomInfo.name));
                coords[i * 3] = atomInfo.pos.x;
                coords[i * 3 + 1] = atomInfo.pos.y;
                coords[i * 3 + 2] = atomInfo.pos.z;
            }
            mol.residues.add(new Residue(atoms, coords, (String)name, mol));
        };
        residuedAtomInfos.forEach((molInfoIndex, byChain) -> byChain.forEach((chainId, byRes) -> byRes.keySet().stream().sorted(Comparator.comparing(resInfoIndex -> this.confSpace.resInfos[resInfoIndex.intValue()].indexInChain)).forEach(resInfoIndex -> {
            List atomInfos = (List)byRes.get(resInfoIndex);
            ConfSpace.ResInfo resInfo = this.confSpace.resInfos[resInfoIndex];
            String resType = assignedResTypes.getOrDefault(resInfoIndex, resInfo.resType);
            String name = String.format("%3s%2s%4s", resType, resInfo.chainId, resInfo.resId);
            usedChainIds.add(resInfo.chainId);
            usedResIds.add(resInfo.resId);
            makeRes.accept(name, atomInfos);
        })));
        molAtomInfos.forEach((molInfoIndex, atomInfos) -> {
            ConfSpace.MolInfo molInfo = this.confSpace.molInfos[molInfoIndex];
            String name = String.format("%3s%2s%4s", molInfo.type != null ? molInfo.type : "XXX", makeChainId.get(), makeResId.get());
            makeRes.accept(name, (List)atomInfos);
        });
        return mol;
    }

    public String getAtomName(int atomi) {
        int posi = this.confSpace.findPosIndex(atomi);
        if (posi == -1) {
            return String.format("Static:%s", this.confSpace.staticNames[atomi]);
        }
        ConfSpace.Pos pos = this.confSpace.positions[posi];
        int confi = this.assignments[posi];
        ConfSpace.Conf conf = pos.confs[confi];
        int offset = atomi - this.confSpace.getConfAtomIndex(posi, 0);
        return String.format("%s:%s", pos.name, conf.atomNames[offset]);
    }

    public List<AtomInfo> atoms() {
        ArrayList<AtomInfo> infos2 = new ArrayList<AtomInfo>();
        for (int atomi = 0; atomi < this.confSpace.staticCoords.size; ++atomi) {
            infos2.add(new AtomInfo(-1, atomi, this.confSpace.getStaticAtomIndex(atomi)));
        }
        for (int posi = 0; posi < this.confSpace.positions.length; ++posi) {
            ConfSpace.Pos pos = this.confSpace.positions[posi];
            ConfSpace.Conf conf = pos.confs[this.assignments[posi]];
            for (int atomi = 0; atomi < conf.numAtoms; ++atomi) {
                infos2.add(new AtomInfo(posi, atomi, this.confSpace.getConfAtomIndex(posi, atomi)));
            }
        }
        return infos2;
    }

    public static class AtomInfo {
        public final int posi;
        public final int atomi;
        public final int coordsi;

        public AtomInfo(int posi, int atomi, int coordsi) {
            this.posi = posi;
            this.atomi = atomi;
            this.coordsi = coordsi;
        }
    }
}

