/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.AbstractTupleMatrix;
import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.ConfSpaceIteration;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.collections4.iterators.ArrayIterator;

public class TupleMatrixDouble
extends AbstractTupleMatrix<Double> {
    private static final long serialVersionUID = -1286639255089978027L;
    private double[] oneBody;
    private double[] pairwise;

    public TupleMatrixDouble(ConfSpace cSpace, double pruningInterval, double defaultHigherInteraction) {
        super(cSpace, pruningInterval, Double.valueOf(defaultHigherInteraction));
    }

    public TupleMatrixDouble(SimpleConfSpace confSpace, double pruningInterval, double defaultHigherInteraction) {
        super(confSpace, pruningInterval, Double.valueOf(defaultHigherInteraction));
    }

    public TupleMatrixDouble(ConfSpaceIteration confSpace) {
        super(confSpace);
    }

    public TupleMatrixDouble(int numPos, int[] numAllowedAtPos, double pruningInterval, double defaultHigherInteraction) {
        super(numPos, numAllowedAtPos, pruningInterval, defaultHigherInteraction);
    }

    public TupleMatrixDouble(TupleMatrixDouble other) {
        super(other);
        this.oneBody = (double[])other.oneBody.clone();
        this.pairwise = (double[])other.pairwise.clone();
    }

    @Override
    protected void allocate(int numOneBody, int numPairwise) {
        this.oneBody = new double[numOneBody];
        this.pairwise = new double[numPairwise];
    }

    @Override
    public Double getOneBody(int res, int conf) {
        return this.oneBody[this.getOneBodyIndex(res, conf)];
    }

    @Override
    public void setOneBody(int res, int conf, Double val) {
        this.oneBody[this.getOneBodyIndex((int)res, (int)conf)] = val;
    }

    @Override
    public void setOneBody(int res, ArrayList<Double> val) {
        int n = this.getNumConfAtPos(res);
        for (int i = 0; i < n; ++i) {
            this.oneBody[this.getOneBodyIndex((int)res, (int)i)] = val.get(i);
        }
    }

    @Override
    public Double getPairwise(int res1, int conf1, int res2, int conf2) {
        return this.pairwise[this.getPairwiseIndex(res1, conf1, res2, conf2)];
    }

    @Override
    public void setPairwise(int res1, int conf1, int res2, int conf2, Double val) {
        this.pairwise[this.getPairwiseIndex((int)res1, (int)conf1, (int)res2, (int)conf2)] = val;
    }

    @Override
    public void setPairwise(int res1, int res2, ArrayList<ArrayList<Double>> val) {
        int n1 = this.getNumConfAtPos(res1);
        int n2 = this.getNumConfAtPos(res2);
        for (int i1 = 0; i1 < n1; ++i1) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.pairwise[this.getPairwiseIndex((int)res1, (int)i1, (int)res2, (int)i2)] = val.get(i1).get(i2);
            }
        }
    }

    @Override
    public void fill(double[] vals) {
        ArrayIterator iter = new ArrayIterator((Object)vals);
        this.fill(iter);
        assert (!iter.hasNext());
    }

    public void negate() {
        int i;
        for (i = 0; i < this.oneBody.length; ++i) {
            this.oneBody[i] = -this.oneBody[i];
        }
        for (i = 0; i < this.pairwise.length; ++i) {
            this.pairwise[i] = -this.pairwise[i];
        }
    }

    public double sum() {
        int i;
        double sum = 0.0;
        for (i = 0; i < this.oneBody.length; ++i) {
            sum += this.oneBody[i];
        }
        for (i = 0; i < this.pairwise.length; ++i) {
            sum += this.pairwise[i];
        }
        return sum;
    }

    public String toString() {
        return this.toString(6, energy -> {
            if (energy == Double.POSITIVE_INFINITY) {
                return String.format("%6s", "inf");
            }
            if (energy == Double.NEGATIVE_INFINITY) {
                return String.format("%6s", "-inf");
            }
            if (energy == 1000.0) {
                return String.format("%6s", "1k");
            }
            if (energy > 1000.0) {
                return String.format("%6s", ">1k");
            }
            if (energy == -1000.0) {
                return String.format("%6s", "-1k");
            }
            if (energy < -1000.0) {
                return String.format("%6s", "<-1k");
            }
            return String.format("%6.2f", energy);
        });
    }

    public String toString(int cellWidth, int precision) {
        return this.toString(cellWidth, energy -> {
            if (energy == Double.POSITIVE_INFINITY) {
                return String.format("%" + cellWidth + "s", "inf");
            }
            if (energy == Double.NEGATIVE_INFINITY) {
                return String.format("%" + cellWidth + "s", "-inf");
            }
            return String.format("%" + cellWidth + "." + precision + "f", energy);
        });
    }

    public String toStringScientific() {
        return this.toString(8, energy -> {
            if (energy == Double.POSITIVE_INFINITY) {
                return String.format("%6s", "inf");
            }
            if (energy == Double.NEGATIVE_INFINITY) {
                return String.format("%6s", "-inf");
            }
            return String.format("%6.1e", energy);
        });
    }

    public void read(DataInputStream in) throws IOException {
        int i;
        for (i = 0; i < this.oneBody.length; ++i) {
            this.oneBody[i] = in.readDouble();
        }
        for (i = 0; i < this.pairwise.length; ++i) {
            this.pairwise[i] = in.readDouble();
        }
    }

    public void write(DataOutputStream out) throws IOException {
        int i;
        for (i = 0; i < this.oneBody.length; ++i) {
            out.writeDouble(this.oneBody[i]);
        }
        for (i = 0; i < this.pairwise.length; ++i) {
            out.writeDouble(this.pairwise[i]);
        }
    }
}

