/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.confspace.ConfSpaceIteration;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.tools.HashCalculator;
import edu.duke.cs.osprey.tools.Streams;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class Conf {
    public static final int Unassigned = -1;

    public static int[] make(SimpleConfSpace confSpace) {
        int[] conf = new int[confSpace.positions.size()];
        Arrays.fill(conf, -1);
        return conf;
    }

    public static int[] make(ConfSpaceIteration confSpace) {
        int[] conf = new int[confSpace.numPos()];
        Arrays.fill(conf, -1);
        return conf;
    }

    public static int[] make(SimpleConfSpace confSpace, RCTuple frag) {
        int[] conf = Conf.make(confSpace);
        for (int i = 0; i < frag.size(); ++i) {
            conf[frag.pos.get((int)i).intValue()] = frag.RCs.get(i);
        }
        return conf;
    }

    public static int[] make(ConfIndex index) {
        int[] conf = new int[index.numPos];
        Conf.clear(conf);
        for (int i = 0; i < index.numDefined; ++i) {
            conf[index.definedPos[i]] = index.definedRCs[i];
        }
        return conf;
    }

    public static void index(int[] conf, ConfIndex index) {
        index.numDefined = 0;
        index.numUndefined = 0;
        for (int pos = 0; pos < conf.length; ++pos) {
            int rc = conf[pos];
            if (rc == -1) {
                index.undefinedPos[index.numUndefined] = pos;
                ++index.numUndefined;
                continue;
            }
            index.definedPos[index.numDefined] = pos;
            index.definedRCs[index.numDefined] = conf[pos];
            ++index.numDefined;
        }
        index.node = null;
    }

    public static ConfIndex index(int[] conf) {
        ConfIndex index = new ConfIndex(conf.length);
        Conf.index(conf, index);
        return index;
    }

    public static void clear(int[] conf) {
        Arrays.fill(conf, -1);
    }

    public static int hashCode(int[] conf) {
        return Arrays.hashCode(conf);
    }

    public static boolean equals(int[] a, int[] b) {
        return Arrays.equals(a, b);
    }

    public static String toString(int[] conf) {
        return Arrays.toString(conf);
    }

    public static String toString(int[] conf, SimpleConfSpace confSpace) {
        return Streams.joinToString(confSpace.positions, ",", p -> {
            int prc = conf[p.index];
            if (prc == -1) {
                return "_";
            }
            SimpleConfSpace.ResidueConf resConf = p.resConfs.get(prc);
            return resConf.template.name + ":" + resConf.getRotamerCode();
        });
    }

    public static boolean isCompletelyUnassigned(int[] conf) {
        for (int i : conf) {
            if (i == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAssignments(int[] conf) {
        return !Conf.isCompletelyUnassigned(conf);
    }

    public static boolean isCompletelyAssigned(int[] conf) {
        for (int i : conf) {
            if (i != -1) continue;
            return false;
        }
        return true;
    }

    public static int countAssignments(int[] conf) {
        int count = 0;
        for (int i : conf) {
            if (i == -1) continue;
            ++count;
        }
        return count;
    }

    public static List<RCTuple> getPairs(int[] conf) {
        ArrayList<RCTuple> pairs = new ArrayList<RCTuple>();
        for (int pos1 = 0; pos1 < conf.length; ++pos1) {
            int rc1 = conf[pos1];
            if (rc1 == -1) continue;
            for (int pos2 = 0; pos2 < pos1; ++pos2) {
                int rc2 = conf[pos2];
                if (rc2 == -1) continue;
                pairs.add(new RCTuple(pos2, rc2, pos1, rc1));
            }
        }
        return pairs;
    }

    public static boolean containsTuple(int[] conf, RCTuple tuple) {
        for (int i = 0; i < tuple.size(); ++i) {
            int rc;
            int pos = tuple.pos.get(i);
            if (conf[pos] == (rc = tuple.RCs.get(i).intValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(Collection<int[]> confs, int[] conf) {
        for (int[] c : confs) {
            if (!Conf.equals(c, conf)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unassignFor(int[] conf, int pos, Runnable block) {
        int rc = conf[pos];
        conf[pos] = -1;
        try {
            block.run();
        }
        finally {
            conf[pos] = rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T unassignFor(int[] conf, int pos, Supplier<T> block) {
        int rc = conf[pos];
        conf[pos] = -1;
        try {
            T t = block.get();
            return t;
        }
        finally {
            conf[pos] = rc;
        }
    }

    private static int[] checkKey(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("key can't be null");
        }
        if (o instanceof int[]) {
            return (int[])o;
        }
        throw new IllegalArgumentException("key is a " + o.getClass().getName() + " instead of an int[]");
    }

    public static class Map<V>
    extends AbstractMap<int[], V> {
        private final HashMap<Wrapper, V> map = new HashMap();

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return key instanceof int[] && this.containsKey((int[])key);
        }

        public boolean containsKey(int[] key) {
            return this.map.containsKey(new Wrapper(key));
        }

        @Override
        public boolean containsValue(Object value2) {
            return this.map.containsValue(value2);
        }

        @Override
        public V get(Object key) {
            return this.get(Conf.checkKey(key));
        }

        public V get(int[] key) {
            return this.map.get(new Wrapper(key));
        }

        @Override
        public V put(int[] key, V value2) {
            return this.map.put(new Wrapper(key), value2);
        }

        @Override
        public V remove(Object key) {
            return this.remove(Conf.checkKey(key));
        }

        public V remove(int[] key) {
            return this.map.remove(new Wrapper(key));
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public java.util.Set<int[]> keySet() {
            return new Set(this.map.keySet());
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }

        @Override
        public java.util.Set<Map.Entry<int[], V>> entrySet() {
            return new AbstractSet<Map.Entry<int[], V>>(){
                private final java.util.Set<Map.Entry<Wrapper, V>> set;
                {
                    this.set = map.entrySet();
                }

                @Override
                public Iterator<Map.Entry<int[], V>> iterator() {
                    return new Iterator<Map.Entry<int[], V>>(){
                        Iterator<Map.Entry<Wrapper, V>> iter;
                        {
                            this.iter = set.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.iter.hasNext();
                        }

                        @Override
                        public Map.Entry<int[], V> next() {
                            return new EntryUnwrapper(this.iter.next());
                        }

                        @Override
                        public void remove() {
                            this.iter.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return this.set.size();
                }

                @Override
                public boolean isEmpty() {
                    return this.set.isEmpty();
                }

                @Override
                public boolean contains(Object o) {
                    return o instanceof Map.Entry && this.contains((Map.Entry)o);
                }

                public boolean contains(Map.Entry<int[], V> entry) {
                    return this.set.contains(new EntryWrapper(entry));
                }

                @Override
                public boolean add(Map.Entry<int[], V> entry) {
                    return this.set.add(new EntryWrapper(entry));
                }

                @Override
                public boolean remove(Object o) {
                    return o instanceof Map.Entry && this.remove((Map.Entry)o);
                }

                public boolean remove(Map.Entry<int[], V> entry) {
                    return this.set.remove(new EntryWrapper(entry));
                }

                @Override
                public void clear() {
                    this.set.clear();
                }

                @Override
                public boolean equals(Object o) {
                    return o instanceof Set && this.equals((Set)o);
                }

                public boolean equals(Set other) {
                    return this.set.equals(other.set);
                }

                @Override
                public int hashCode() {
                    return this.set.hashCode();
                }

                @Override
                public String toString() {
                    return this.set.toString();
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map && this.equals((Map)o);
        }

        public boolean equals(Map other) {
            return this.map.equals(other.map);
        }

        @Override
        public int hashCode() {
            return this.map.hashCode();
        }

        @Override
        public String toString() {
            return this.map.toString();
        }

        private static class EntryUnwrapper<V>
        implements Map.Entry<int[], V> {
            private Map.Entry<Wrapper, V> entry;

            public EntryUnwrapper(Map.Entry<Wrapper, V> entry) {
                this.entry = entry;
            }

            @Override
            public int[] getKey() {
                return this.entry.getKey().assignments;
            }

            @Override
            public V getValue() {
                return this.entry.getValue();
            }

            @Override
            public V setValue(V value2) {
                return this.entry.setValue(value2);
            }

            @Override
            public int hashCode() {
                return this.entry.hashCode();
            }

            @Override
            public boolean equals(Object o) {
                return o instanceof Map.Entry && this.equals((Map.Entry)o);
            }

            public boolean equals(Map.Entry<int[], V> other) {
                return Conf.equals(this.getKey(), other.getKey()) && Objects.equals(this.getValue(), other.getValue());
            }

            public String toString() {
                return String.format("%s=%s", this.entry.getKey(), this.getValue());
            }
        }

        private static class EntryWrapper<V>
        implements Map.Entry<Wrapper, V> {
            private Map.Entry<int[], V> entry;
            private Wrapper wrapper;

            public EntryWrapper(Map.Entry<int[], V> entry) {
                this.entry = entry;
                this.wrapper = new Wrapper(entry.getKey());
            }

            @Override
            public Wrapper getKey() {
                return this.wrapper;
            }

            @Override
            public V getValue() {
                return this.entry.getValue();
            }

            @Override
            public V setValue(V value2) {
                return this.entry.setValue(value2);
            }

            @Override
            public int hashCode() {
                return HashCalculator.combineHashes(this.wrapper.hashCode(), Objects.hashCode(this.entry.getValue()));
            }

            @Override
            public boolean equals(Object o) {
                return o instanceof Map.Entry && this.equals((Map.Entry)o);
            }

            public boolean equals(Map.Entry<int[], V> other) {
                return Conf.equals(this.wrapper.assignments, other.getKey()) && Objects.equals(this.getValue(), other.getValue());
            }

            public String toString() {
                return String.format("%s=%s", this.getKey(), this.getValue());
            }
        }
    }

    public static class Set
    extends AbstractSet<int[]> {
        private java.util.Set<Wrapper> set;

        public Set() {
            this((java.util.Set<Wrapper>)new HashSet<Wrapper>());
        }

        public Set(java.util.Set<Wrapper> set) {
            this.set = set;
        }

        public Set(Collection<int[]> source) {
            this();
            this.addAll(source);
        }

        public Set(int[] ... confs) {
            this();
            for (int[] conf : confs) {
                this.add(conf);
            }
        }

        @Override
        public Iterator<int[]> iterator() {
            return new Iterator<int[]>(){
                Iterator<Wrapper> iter;
                {
                    this.iter = set.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public int[] next() {
                    return this.iter.next().assignments;
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.contains(Conf.checkKey(o));
        }

        public boolean contains(int[] conf) {
            return this.set.contains(new Wrapper(conf));
        }

        @Override
        public boolean add(int[] conf) {
            return this.set.add(new Wrapper(conf));
        }

        @Override
        public boolean remove(Object o) {
            return this.remove(Conf.checkKey(o));
        }

        public boolean remove(int[] conf) {
            return this.set.remove(new Wrapper(conf));
        }

        @Override
        public void clear() {
            this.set.clear();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Set && this.equals((Set)o);
        }

        public boolean equals(Set other) {
            return this.set.equals(other.set);
        }

        @Override
        public int hashCode() {
            return this.set.hashCode();
        }

        @Override
        public String toString() {
            return this.set.toString();
        }
    }

    private static class Wrapper {
        final int[] assignments;

        public Wrapper(int[] assignments) {
            this.assignments = assignments;
        }

        public int hashCode() {
            return Conf.hashCode(this.assignments);
        }

        public boolean equals(Object other) {
            return other instanceof Wrapper && this.equals((Wrapper)other);
        }

        public boolean equals(Wrapper other) {
            return Conf.equals(this.assignments, other.assignments);
        }

        public String toString() {
            return Conf.toString(this.assignments);
        }
    }
}

