/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.bbfree.BBFreeBlock;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.Strand;
import edu.duke.cs.osprey.confspace.StrandFlex;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class CATSStrandFlex
extends StrandFlex {
    BBFreeBlock block;

    public CATSStrandFlex(Strand strand, String firstRes, String lastRes) {
        List<Residue> catsRes = strand.mol.getResRangeByPDBResNumber(firstRes, lastRes);
        this.block = new BBFreeBlock(catsRes);
    }

    @Override
    public List<? extends DegreeOfFreedom> makeDofs(Strand strand, Molecule mol) {
        BBFreeBlock molBlock = (BBFreeBlock)this.block.copyForNewMolecule(mol, new LinkedHashMap<DegreeOfFreedom, DegreeOfFreedom>());
        return molBlock.getDOFs();
    }

    @Override
    public ObjectiveFunction.DofBounds makeBounds(Strand strand) {
        double[][] freeDOFVoxel = this.block.getFreeDOFVoxel();
        int numDOFs = freeDOFVoxel[0].length;
        ObjectiveFunction.DofBounds ans = new ObjectiveFunction.DofBounds(numDOFs);
        for (int d = 0; d < numDOFs; ++d) {
            ans.set(d, freeDOFVoxel[0][d], freeDOFVoxel[1][d]);
        }
        return ans;
    }

    @Override
    public ArrayList<HashMap<String, double[]>> listBackboneVoxels(SimpleConfSpace.Position pos) {
        ArrayList<HashMap<String, double[]>> retList = new ArrayList<HashMap<String, double[]>>();
        if (this.doesBlockAffectResidue(pos.resNum)) {
            retList.add(this.defaultBackboneVoxel(pos.strand));
        }
        return retList;
    }

    private boolean doesBlockAffectResidue(String resNum) {
        return this.block.getResidues().stream().anyMatch(residue -> residue.getPDBResNumber().equalsIgnoreCase(resNum));
    }
}

