/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.ConfSpaceIteration;
import edu.duke.cs.osprey.confspace.HigherTupleFinder;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.TupleMatrix;
import edu.duke.cs.osprey.confspace.TupleTree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractTupleMatrix<T>
implements TupleMatrix<T>,
Serializable {
    private static final long serialVersionUID = 1654821458320722522L;
    private int numPos;
    private int[] numConfAtPos;
    private int[] oneBodyOffsets;
    private int numOneBodyTerms;
    private int[] pairwiseOffsets;
    private int numPairwiseTerms;
    private double pruningInterval;
    @Deprecated
    private ArrayList<HigherTupleFinder<T>> higherTerms;
    private T defaultHigherInteraction;
    private TupleTree<T>[] tupleTrees = null;

    protected AbstractTupleMatrix() {
    }

    protected AbstractTupleMatrix(ConfSpace cSpace, double pruningInterval, T defaultHigherInteraction) {
        this(cSpace.numPos, cSpace.getNumRCsAtPos(), pruningInterval, defaultHigherInteraction);
    }

    protected AbstractTupleMatrix(SimpleConfSpace confSpace, double pruningInterval, T defaultHigherInteraction) {
        this(confSpace.positions.size(), confSpace.getNumResConfsByPos(), pruningInterval, defaultHigherInteraction);
    }

    protected AbstractTupleMatrix(ConfSpaceIteration confSpace) {
        this(confSpace.numPos(), confSpace.numConfsByPos(), 0.0, null);
    }

    protected AbstractTupleMatrix(int numPos, int[] numConfAtPos, double pruningInterval, T defaultHigherInteraction) {
        this.pruningInterval = pruningInterval;
        this.defaultHigherInteraction = defaultHigherInteraction;
        this.numPos = numPos;
        this.numConfAtPos = numConfAtPos;
        int oneBodyOffset = 0;
        this.oneBodyOffsets = new int[numPos];
        for (int res1 = 0; res1 < numPos; ++res1) {
            this.oneBodyOffsets[res1] = oneBodyOffset;
            oneBodyOffset += numConfAtPos[res1];
        }
        this.numOneBodyTerms = oneBodyOffset;
        this.pairwiseOffsets = new int[numPos * (numPos - 1) / 2];
        int pairwiseOffset = 0;
        int pairwiseIndex = 0;
        for (int res1 = 0; res1 < numPos; ++res1) {
            for (int res2 = 0; res2 < res1; ++res2) {
                this.pairwiseOffsets[pairwiseIndex++] = pairwiseOffset;
                pairwiseOffset += numConfAtPos[res1] * numConfAtPos[res2];
            }
        }
        this.numPairwiseTerms = pairwiseOffset;
        assert (pairwiseIndex == this.pairwiseOffsets.length);
        this.allocate(this.numOneBodyTerms, this.numPairwiseTerms);
        this.higherTerms = null;
    }

    protected AbstractTupleMatrix(AbstractTupleMatrix<T> other) {
        this.numPos = other.numPos;
        this.numConfAtPos = (int[])other.numConfAtPos.clone();
        this.oneBodyOffsets = (int[])other.oneBodyOffsets.clone();
        this.pairwiseOffsets = (int[])other.pairwiseOffsets.clone();
        this.numPairwiseTerms = other.numPairwiseTerms;
        this.pruningInterval = other.pruningInterval;
        if (other.higherTerms != null) {
            throw new UnsupportedOperationException("copying higher order terms isn't implemented yet");
        }
        this.higherTerms = null;
        this.defaultHigherInteraction = null;
    }

    protected abstract void allocate(int var1, int var2);

    @Override
    public double getPruningInterval() {
        return this.pruningInterval;
    }

    public void setPruningInterval(double pruningInterval) {
        this.pruningInterval = pruningInterval;
    }

    public T getDefaultHigherInteraction() {
        return this.defaultHigherInteraction;
    }

    @Override
    public int getNumPos() {
        return this.numPos;
    }

    @Override
    public int getNumConfAtPos(int pos) {
        return this.numConfAtPos[pos];
    }

    public int[] getNumConfAtPos() {
        return this.numConfAtPos;
    }

    public int getNumOneBody() {
        return this.numOneBodyTerms;
    }

    public int getNumPairwise() {
        return this.numPairwiseTerms;
    }

    public int getOneBodyIndex(int res, int conf) {
        return this.oneBodyOffsets[res] + conf;
    }

    private int getPairwiseIndexNoCheck(int res1, int res2) {
        return res1 * (res1 - 1) / 2 + res2;
    }

    public int getPairwiseIndex(int res1, int res2) {
        if (res2 > res1) {
            int swap = res1;
            res1 = res2;
            res2 = swap;
        } else if (res1 == res2) {
            throw new Error("Can't pair residue " + res1 + " with itself");
        }
        return this.getPairwiseIndexNoCheck(res1, res2);
    }

    public int getPairwiseIndex(int res1, int conf1, int res2, int conf2) {
        if (res2 > res1) {
            int swap = res1;
            res1 = res2;
            res2 = swap;
            swap = conf1;
            conf1 = conf2;
            conf2 = swap;
        } else if (res1 == res2) {
            throw new Error("Can't pair residue " + res1 + " with itself");
        }
        return this.pairwiseOffsets[this.getPairwiseIndexNoCheck(res1, res2)] + this.numConfAtPos[res2] * conf1 + conf2;
    }

    @Override
    public void fill(T val) {
        for (int res1 = 0; res1 < this.getNumPos(); ++res1) {
            int m1 = this.getNumConfAtPos(res1);
            for (int i1 = 0; i1 < m1; ++i1) {
                this.setOneBody(res1, i1, val);
                for (int res2 = 0; res2 < res1; ++res2) {
                    int m2 = this.getNumConfAtPos(res2);
                    for (int i2 = 0; i2 < m2; ++i2) {
                        this.setPairwise(res1, i1, res2, i2, val);
                    }
                }
            }
        }
    }

    @Override
    public void fill(Iterator<T> val) {
        for (int res1 = 0; res1 < this.getNumPos(); ++res1) {
            int m1 = this.getNumConfAtPos(res1);
            for (int i1 = 0; i1 < m1; ++i1) {
                this.setOneBody(res1, i1, val.next());
                for (int res2 = 0; res2 < res1; ++res2) {
                    int m2 = this.getNumConfAtPos(res2);
                    for (int i2 = 0; i2 < m2; ++i2) {
                        this.setPairwise(res1, i1, res2, i2, val.next());
                    }
                }
            }
        }
    }

    public boolean matches(ConfSpaceIteration confSpace) {
        if (this.getNumPos() != confSpace.numPos()) {
            return false;
        }
        for (int posi = 0; posi < this.getNumPos(); ++posi) {
            if (confSpace.numConf(posi) == this.numConfAtPos[posi]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasHigherOrderTerms() {
        return this.higherTerms != null;
    }

    @Override
    public void setTupleValue(RCTuple tup, T val) {
        int tupSize = tup.pos.size();
        if (tupSize == 1) {
            this.setOneBody(tup.pos.get(0), tup.RCs.get(0), val);
        } else if (tupSize == 2) {
            this.setPairwise(tup.pos.get(0), tup.RCs.get(0), tup.pos.get(1), tup.RCs.get(1), val);
        } else if (tupSize > 2) {
            this.setHigherOrder(tup, val);
        } else {
            throw new UnsupportedOperationException("ERROR: Not supporting tuple size " + tupSize);
        }
    }

    public void setHigherOrder(RCTuple tup, T val) {
        for (int index1 = 0; index1 < tup.pos.size(); ++index1) {
            for (int index2 = 0; index2 < index1; ++index2) {
                int rc2;
                int pos2;
                int rc1;
                int pos1 = tup.pos.get(index1);
                HigherTupleFinder<T> htf = this.getHigherOrderTerms(pos1, rc1 = tup.RCs.get(index1).intValue(), pos2 = tup.pos.get(index2).intValue(), rc2 = tup.RCs.get(index2).intValue());
                if (htf == null) {
                    htf = new HigherTupleFinder<T>(this.defaultHigherInteraction);
                    this.setHigherOrderTerms(pos1, rc1, pos2, rc2, htf);
                }
                RCTuple subTup = tup.subtractMember(index1).subtractMember(index2);
                htf.setInteraction(subTup, val);
            }
        }
    }

    @Override
    public HigherTupleFinder<T> getHigherOrderTerms(int res1, int conf1, int res2, int conf2) {
        if (this.higherTerms != null) {
            return this.higherTerms.get(this.getPairwiseIndex(res1, conf1, res2, conf2));
        }
        return null;
    }

    @Override
    public void setHigherOrderTerms(int res1, int conf1, int res2, int conf2, HigherTupleFinder<T> val) {
        if (val != null && this.higherTerms == null) {
            this.higherTerms = new ArrayList(this.numPairwiseTerms);
            for (int i = 0; i < this.numPairwiseTerms; ++i) {
                this.higherTerms.add(null);
            }
        }
        if (this.higherTerms != null) {
            this.higherTerms.set(this.getPairwiseIndex(res1, conf1, res2, conf2), val);
        }
    }

    @Override
    public boolean hasHigherOrderTuples() {
        return this.tupleTrees != null;
    }

    @Override
    public TupleTree<T> getHigherOrderTuples(int pos1, int rc1, int pos2, int rc2) {
        if (this.tupleTrees == null) {
            return null;
        }
        return this.tupleTrees[this.getPairwiseIndex(pos1, rc1, pos2, rc2)];
    }

    @Override
    public TupleTree<T> getOrMakeHigherOrderTuples(int pos1, int rc1, int pos2, int rc2) {
        int index;
        TupleTree<T> tree;
        if (this.tupleTrees == null) {
            this.tupleTrees = new TupleTree[this.numPairwiseTerms];
        }
        if ((tree = this.tupleTrees[index = this.getPairwiseIndex(pos1, rc1, pos2, rc2)]) == null) {
            this.tupleTrees[index] = tree = new TupleTree(new RCTuple(pos1, rc1, pos2, rc2).sorted());
        }
        return tree;
    }

    public String toString(int cellWidth, Function<T, String> formatter) {
        int rc1;
        int n1;
        int pos1;
        StringBuilder buf = new StringBuilder();
        int fCellWidth = Math.max(cellWidth, 6);
        String spacer = "  ";
        Consumer<String> center = val -> {
            int length = val.length();
            if (length > fCellWidth) {
                buf.append(val.substring(0, fCellWidth));
                return;
            }
            int pad = fCellWidth - length;
            int halfPad = pad / 2;
            if (pad % 2 == 0) {
                int i;
                for (i = 0; i < halfPad; ++i) {
                    buf.append(" ");
                }
                buf.append((String)val);
                for (i = 0; i < halfPad; ++i) {
                    buf.append(" ");
                }
            } else {
                int i;
                for (i = 0; i < halfPad; ++i) {
                    buf.append(" ");
                }
                buf.append((String)val);
                for (i = 0; i < halfPad + 1; ++i) {
                    buf.append(" ");
                }
            }
        };
        Consumer<Integer> posPrinter = pos -> {
            buf.append("  ");
            center.accept(String.format("%d", pos));
        };
        Consumer<Integer> rcPrinter = rc -> {
            buf.append("  ");
            center.accept(String.format("%3d", rc));
        };
        BiConsumer<Integer, Integer> labelPrinter = (pos, rc) -> {
            String label2 = String.format("%2d:%-3d", pos, rc);
            buf.append(String.format("%s%-" + fCellWidth + "s", "  ", label2));
        };
        Consumer<Object> valuePrinter = energy -> {
            String value2 = (String)formatter.apply(energy);
            buf.append("  ");
            buf.append(String.format("%" + fCellWidth + "s", value2));
        };
        Runnable blankPrinter = () -> {
            buf.append("  ");
            for (int i = 0; i < fCellWidth; ++i) {
                buf.append(" ");
            }
        };
        int maxNumRcs = 0;
        for (pos1 = 0; pos1 < this.getNumPos(); ++pos1) {
            maxNumRcs = Math.max(maxNumRcs, this.getNumConfAtPos(pos1));
        }
        buf.append("singles:\n");
        blankPrinter.run();
        for (int rc2 = 0; rc2 < maxNumRcs; ++rc2) {
            rcPrinter.accept(rc2);
        }
        buf.append("\n");
        for (pos1 = 0; pos1 < this.getNumPos(); ++pos1) {
            n1 = this.getNumConfAtPos(pos1);
            posPrinter.accept(pos1);
            for (rc1 = 0; rc1 < n1; ++rc1) {
                valuePrinter.accept(this.getOneBody(pos1, rc1));
            }
            buf.append("\n");
        }
        buf.append("pairs:\n");
        blankPrinter.run();
        for (pos1 = 0; pos1 < this.getNumPos() - 1; ++pos1) {
            n1 = this.getNumConfAtPos(pos1);
            for (rc1 = 0; rc1 < n1; ++rc1) {
                labelPrinter.accept(pos1, rc1);
            }
        }
        buf.append("\n");
        for (pos1 = 1; pos1 < this.getNumPos(); ++pos1) {
            n1 = this.getNumConfAtPos(pos1);
            for (rc1 = 0; rc1 < n1; ++rc1) {
                labelPrinter.accept(pos1, rc1);
                for (int pos2 = 0; pos2 < pos1; ++pos2) {
                    int n2 = this.getNumConfAtPos(pos2);
                    for (int rc2 = 0; rc2 < n2; ++rc2) {
                        valuePrinter.accept(this.getPairwise(pos1, rc1, pos2, rc2));
                    }
                }
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    public boolean equals(Object other) {
        return other instanceof AbstractTupleMatrix && this.equals((AbstractTupleMatrix)other);
    }

    public boolean equals(AbstractTupleMatrix<?> other) {
        if (this.getNumPos() != other.getNumPos()) {
            return false;
        }
        int n = this.getNumPos();
        for (int pos1 = 0; pos1 < n; ++pos1) {
            if (this.getNumConfAtPos(pos1) != other.getNumConfAtPos(pos1)) {
                return false;
            }
            int n1 = this.getNumConfAtPos(pos1);
            for (int rc1 = 0; rc1 < n1; ++rc1) {
                if (!Objects.equals(this.getOneBody(pos1, rc1), other.getOneBody(pos1, rc1))) {
                    return false;
                }
                for (int pos2 = 0; pos2 < pos1; ++pos2) {
                    if (this.getNumConfAtPos(pos2) != other.getNumConfAtPos(pos2)) {
                        return false;
                    }
                    int n2 = this.getNumConfAtPos(pos2);
                    for (int rc2 = 0; rc2 < n2; ++rc2) {
                        if (Objects.equals(this.getPairwise(pos1, rc1, pos2, rc2), other.getPairwise(pos1, rc1, pos2, rc2))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean hasHigherOrderTermFor(RCTuple query) {
        int rc2;
        int pos2;
        int rc1;
        int pos1 = query.pos.get(0);
        HigherTupleFinder<T> htf = this.getHigherOrderTerms(pos1, rc1 = query.RCs.get(0).intValue(), pos2 = query.pos.get(1).intValue(), rc2 = query.RCs.get(1).intValue());
        if (htf == null) {
            return false;
        }
        for (int tupIndex = 2; tupIndex < query.size(); ++tupIndex) {
            HigherTupleFinder<T> highertf = htf.getHigherInteractions(query.pos.get(tupIndex), query.RCs.get(tupIndex));
            if (highertf == null) {
                return false;
            }
            htf = highertf;
        }
        return true;
    }
}

