/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.bbfree;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Functions;
import edu.duke.cs.osprey.bbfree.BBFreeBlock;
import edu.duke.cs.osprey.bbfree.PepPlaneLinModel;
import edu.duke.cs.osprey.ematrix.epic.SeriesFitter;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.VectorAlgebra;
import java.util.ArrayList;
import java.util.List;

public class VoxelSeriesChecker {
    static int numSamples = 50;
    int numRes;
    int numFreeDOFs;
    int numFullDOFs;
    double[][] NCoord;
    double[][] CACoord;
    double[][] CCoord;
    double[][] fullDOFPolys;
    ArrayList<Double> targetConstraintVals;
    PepPlaneLinModel[] pepPlanes;
    DoubleMatrix2D freeDOFMatrix;
    DoubleMatrix1D freeDOFCenter;

    public VoxelSeriesChecker(List<Residue> residues, int numFreeDOFs, int numFullDOFs, double[][] fullDOFPolys, PepPlaneLinModel[] pepPlanes, DoubleMatrix2D freeDOFMatrix, DoubleMatrix1D freeDOFCenter) {
        int resNum;
        this.numRes = residues.size();
        this.numFreeDOFs = numFreeDOFs;
        this.numFullDOFs = numFullDOFs;
        this.fullDOFPolys = fullDOFPolys;
        this.pepPlanes = pepPlanes;
        this.freeDOFMatrix = freeDOFMatrix;
        this.freeDOFCenter = freeDOFCenter;
        this.NCoord = new double[this.numRes][];
        this.CACoord = new double[this.numRes][];
        this.CCoord = new double[this.numRes][];
        for (resNum = 0; resNum < this.numRes; ++resNum) {
            this.NCoord[resNum] = residues.get(resNum).getCoordsByAtomName("N");
            this.CACoord[resNum] = residues.get(resNum).getCoordsByAtomName("CA");
            if (resNum != this.numRes - 1) continue;
            this.CCoord[resNum] = residues.get(resNum).getCoordsByAtomName("C");
        }
        for (resNum = 0; resNum < this.numRes - 1; ++resNum) {
            this.CCoord[resNum] = pepPlanes[resNum].calcCCoords(this.CACoord[resNum], this.NCoord[resNum + 1], this.CACoord[resNum + 1], true);
        }
        this.targetConstraintVals = this.calcConstraintVals();
    }

    double[] sampleResid(double[][] freeDOFVoxel) {
        int resNum;
        DoubleMatrix1D sampFreeDOFs = DoubleFactory1D.dense.make(this.numFreeDOFs);
        for (int freeDOF = 0; freeDOF < this.numFreeDOFs; ++freeDOF) {
            double voxWidth = freeDOFVoxel[1][freeDOF] - freeDOFVoxel[0][freeDOF];
            sampFreeDOFs.set(freeDOF, freeDOFVoxel[0][freeDOF] + Math.random() * voxWidth);
        }
        int fullDOFCount = 0;
        DoubleMatrix1D fullDOFVals = DoubleFactory1D.dense.make(this.numFullDOFs);
        for (resNum = 1; resNum < this.numRes; ++resNum) {
            int dim;
            for (dim = 0; dim < 3; ++dim) {
                this.NCoord[resNum][dim] = this.evalFullDOF(fullDOFCount, sampFreeDOFs);
                fullDOFVals.set(fullDOFCount, this.NCoord[resNum][dim]);
                ++fullDOFCount;
            }
            if (resNum == this.numRes - 1) break;
            for (dim = 0; dim < 3; ++dim) {
                this.CACoord[resNum][dim] = this.evalFullDOF(fullDOFCount, sampFreeDOFs);
                fullDOFVals.set(fullDOFCount, this.CACoord[resNum][dim]);
                ++fullDOFCount;
            }
        }
        for (resNum = 0; resNum < this.numRes - 1; ++resNum) {
            this.CCoord[resNum] = this.pepPlanes[resNum].calcCCoords(this.CACoord[resNum], this.NCoord[resNum + 1], this.CACoord[resNum + 1], true);
        }
        ArrayList<Double> sampConstraintVals = this.calcConstraintVals();
        double constrResid = 0.0;
        for (int c = 0; c < this.numFullDOFs - this.numFreeDOFs; ++c) {
            double dev = sampConstraintVals.get(c) - this.targetConstraintVals.get(c);
            constrResid += dev * dev;
        }
        constrResid /= (double)(this.numFullDOFs - this.numFreeDOFs);
        DoubleMatrix1D freeDOFsCheck = Algebra.DEFAULT.mult(this.freeDOFMatrix, fullDOFVals);
        freeDOFsCheck.assign(this.freeDOFCenter, Functions.minus);
        freeDOFsCheck.assign(sampFreeDOFs, Functions.minus);
        double freeDOFResid = freeDOFsCheck.zDotProduct(freeDOFsCheck) / (double)this.numFreeDOFs;
        return new double[]{constrResid, freeDOFResid};
    }

    private ArrayList<Double> calcConstraintVals() {
        ArrayList<Double> ans = new ArrayList<Double>();
        for (int resNum = 0; resNum < this.numRes; ++resNum) {
            if (resNum > 0) {
                ans.add(VectorAlgebra.distance(this.NCoord[resNum], this.CACoord[resNum]));
                ans.add(VectorAlgebra.distance(this.CACoord[resNum - 1], this.CACoord[resNum]));
                ans.add(VectorAlgebra.distance(this.NCoord[resNum], this.CACoord[resNum - 1]));
            }
            ans.add(VectorAlgebra.dot(VectorAlgebra.subtract(this.NCoord[resNum], this.CACoord[resNum]), VectorAlgebra.subtract(this.CCoord[resNum], this.CACoord[resNum])));
        }
        return ans;
    }

    private double evalFullDOF(int fullDOF, DoubleMatrix1D sampFreeDOFs) {
        return SeriesFitter.evalSeries(this.fullDOFPolys[fullDOF], sampFreeDOFs, this.numFreeDOFs, true, BBFreeBlock.polyOrder);
    }

    public double getConstraintsResid(double[][] freeDOFVoxel) {
        double constrResid = 0.0;
        double freeDOFResid = 0.0;
        for (int samp = 0; samp < numSamples; ++samp) {
            double[] resids = this.sampleResid(freeDOFVoxel);
            constrResid += resids[0];
            freeDOFResid += resids[1];
        }
        System.out.println("Free DOF resid: " + (freeDOFResid /= (double)numSamples));
        return constrResid /= (double)numSamples;
    }
}

