/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.seq;

import edu.duke.cs.osprey.astar.seq.nodes.SeqAStarNode;
import edu.duke.cs.osprey.confspace.SeqSpace;
import java.math.BigInteger;
import java.util.Arrays;

public class RTs {
    public final int numPos;
    private final int[] wildTypesByPos;
    private final int[][] indicesByPos;

    public RTs(SeqSpace seqSpace) {
        this.numPos = seqSpace.positions.size();
        this.wildTypesByPos = new int[this.numPos];
        this.indicesByPos = new int[this.numPos][];
        for (SeqSpace.Position pos : seqSpace.positions) {
            this.wildTypesByPos[pos.index] = pos.wildType != null ? pos.wildType.index : -1;
            int[] indices = new int[pos.resTypes.size()];
            for (int i = 0; i < pos.resTypes.size(); ++i) {
                indices[i] = i;
            }
            this.indicesByPos[pos.index] = indices;
        }
    }

    public RTs(RTs other, Filter filter) {
        this.numPos = other.numPos;
        this.wildTypesByPos = (int[])other.wildTypesByPos.clone();
        this.indicesByPos = new int[this.numPos][];
        for (int mpos = 0; mpos < this.numPos; ++mpos) {
            int fmpos = mpos;
            this.indicesByPos[mpos] = Arrays.stream(other.indicesByPos[mpos]).filter((int rt) -> filter.test(fmpos, rt)).toArray();
        }
    }

    public RTs filter(Filter filter) {
        return new RTs(this, filter);
    }

    public int numTypesAt(int pos) {
        return this.indicesAt(pos).length;
    }

    public int[] indicesAt(int pos) {
        return this.indicesByPos[pos];
    }

    public int wildTypeAt(int pos) {
        return this.wildTypesByPos[pos];
    }

    public BigInteger getNumSequences() {
        if (this.numPos <= 0) {
            return BigInteger.ZERO;
        }
        for (int[] rts : this.indicesByPos) {
            if (rts.length > 0) continue;
            return BigInteger.ZERO;
        }
        BigInteger count = BigInteger.ONE;
        for (int[] rts : this.indicesByPos) {
            count = count.multiply(BigInteger.valueOf(rts.length));
        }
        return count;
    }

    public int getNumTrivialPos() {
        return (int)Arrays.stream(this.indicesByPos).filter((? super T indices) -> ((int[])indices).length == 1).count();
    }

    public int getNumMutations(SeqAStarNode.Assignments assignments) {
        int count = 0;
        for (int i = 0; i < assignments.numAssigned; ++i) {
            int rt = assignments.assignedRTs[i];
            int pos = assignments.assignedPos[i];
            if (rt == this.wildTypesByPos[pos]) continue;
            ++count;
        }
        return count;
    }

    public static interface Filter {
        public boolean test(int var1, int var2);
    }
}

