/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.conf.smastar;

import edu.duke.cs.osprey.astar.OptimizableAStarNode;
import edu.duke.cs.osprey.astar.conf.ConfAStarNode;
import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.astar.conf.smastar.ConfSMAStarQueue;
import edu.duke.cs.osprey.tools.MathTools;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ConfSMAStarNode
implements ConfAStarNode {
    public final ConfSMAStarNode parent;
    public final int index;
    public final int depth;
    public final int pos;
    public final int rc;
    private double gscore = 0.0;
    private double hscore = 0.0;
    private double fscore = Double.NaN;
    private ConfSMAStarNode[] spawnedChildren = null;
    private State[] childStates = null;
    private double[] forgottenScores = null;

    public ConfSMAStarNode() {
        this(null, -1, 0, -1, -1);
    }

    private ConfSMAStarNode(ConfSMAStarNode parent, int index, int depth, int pos, int rc) {
        this.parent = parent;
        this.index = index;
        this.depth = depth;
        this.pos = pos;
        this.rc = rc;
    }

    private void allocateChildren(int numChildren) {
        this.spawnedChildren = new ConfSMAStarNode[numChildren];
        Arrays.fill(this.spawnedChildren, null);
        this.childStates = new State[numChildren];
        Arrays.fill((Object[])this.childStates, (Object)State.Unspawned);
        this.forgottenScores = new double[numChildren];
        Arrays.fill(this.forgottenScores, Double.NaN);
    }

    @Override
    public void getConf(int[] conf) {
        ConfSMAStarNode node = this;
        while (node.depth > 0) {
            conf[node.pos] = node.rc;
            node = node.parent;
        }
    }

    @Override
    public double getScore() {
        return this.fscore;
    }

    public void setScore(double val) {
        this.fscore = val;
    }

    @Override
    public double getScore(MathTools.Optimizer optimizer) {
        return OptimizableAStarNode.Tools.optimizeScore(this.getScore(), optimizer);
    }

    public void setScore(double val, MathTools.Optimizer optimizer) {
        this.setScore(OptimizableAStarNode.Tools.optimizeScore(val, optimizer));
    }

    @Override
    public double getGScore() {
        return this.gscore;
    }

    @Override
    public void setGScore(double val) {
        this.gscore = val;
    }

    @Override
    public double getHScore() {
        return this.hscore;
    }

    @Override
    public void setHScore(double val) {
        this.hscore = val;
    }

    @Override
    public int getLevel() {
        return this.depth;
    }

    @Override
    public void index(ConfIndex index) {
        index.numDefined = this.depth;
        ConfSMAStarNode node = this;
        while (node.depth > 0) {
            int i = node.depth - 1;
            index.definedPos[i] = node.pos;
            index.definedRCs[i] = node.rc;
            node = node.parent;
        }
        index.node = this;
        index.sortDefined();
        index.updateUndefined();
    }

    public int getNextChildIndex(int numChildren) {
        if (this.spawnedChildren == null) {
            this.allocateChildren(numChildren);
        }
        for (int i = 0; i < this.childStates.length; ++i) {
            if (this.childStates[i] != State.Unspawned) continue;
            return i;
        }
        int bestIndex = -1;
        double bestForgottenScore = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.childStates.length; ++i) {
            if (this.childStates[i] != State.Forgotten || !(this.forgottenScores[i] < bestForgottenScore)) continue;
            bestForgottenScore = this.forgottenScores[i];
            bestIndex = i;
        }
        if (bestIndex >= 0) {
            return bestIndex;
        }
        throw new Error("No more children to spawn");
    }

    @Override
    public ConfAStarNode assign(int pos, int rc) {
        throw new UnsupportedOperationException("need the child index, call spawnChild instead");
    }

    public ConfSMAStarNode spawnChild(int pos, int rc, int index) {
        ConfSMAStarNode child;
        this.spawnedChildren[index] = child = new ConfSMAStarNode(this, index, this.depth + 1, pos, rc);
        this.childStates[index] = State.Spawned;
        this.forgottenScores[index] = Double.NaN;
        return child;
    }

    public void forgetChild(ConfSMAStarNode child) {
        assert (this.spawnedChildren[child.index] == child);
        this.childStates[child.index] = State.Forgotten;
        this.forgottenScores[child.index] = child.fscore;
        this.spawnedChildren[child.index] = null;
    }

    public int finishChild(ConfSMAStarNode child, ConfSMAStarQueue q) {
        assert (this.spawnedChildren[child.index] == child);
        q.removeOrAssert(child);
        child.fscore = Double.POSITIVE_INFINITY;
        this.childStates[child.index] = State.Finished;
        this.forgottenScores[child.index] = Double.POSITIVE_INFINITY;
        this.backup(q);
        this.spawnedChildren[child.index] = null;
        int numNodesRemoved = 1;
        ConfSMAStarNode node = this;
        while (node != null && node.allChildrenFinished()) {
            q.remove(node);
            if (node.parent != null) {
                node.parent.childStates[node.index] = State.Finished;
                node.parent.forgottenScores[node.index] = Double.POSITIVE_INFINITY;
                node.parent.spawnedChildren[node.index] = null;
            }
            ++numNodesRemoved;
            node = node.parent;
        }
        return numNodesRemoved;
    }

    public void backup(ConfSMAStarQueue q) {
        ConfSMAStarNode node = this;
        while (node != null && node.haveAllChildScores()) {
            double oldScore = node.fscore;
            double newScore = Double.POSITIVE_INFINITY;
            for (ConfSMAStarNode child : node.spawnedChildren) {
                if (child == null) continue;
                newScore = Math.min(newScore, child.fscore);
            }
            for (double score : node.forgottenScores) {
                if (Double.isNaN(score)) continue;
                newScore = Math.min(newScore, score);
            }
            if (newScore == oldScore) break;
            boolean bl = q.remove(node);
            node.fscore = newScore;
            if (bl) {
                q.addOrAssert(node);
            }
            node = node.parent;
        }
    }

    public String getPath() {
        assert (this.depth == 0 || this.parent != null) : String.format("%d:%d <- null", this.pos, this.rc);
        StringBuilder buf = new StringBuilder();
        ConfSMAStarNode node = this;
        if (node.depth == 0) {
            buf.append("(root)");
        }
        while (node.depth > 0) {
            if (buf.length() > 0) {
                buf.append(" <- ");
            }
            buf.append(node.pos);
            buf.append(":");
            buf.append(node.rc);
            assert (node.parent != null) : buf.toString() + " <- null";
            node = node.parent;
        }
        return buf.toString();
    }

    public String toString() {
        return String.format("%s   %9.4f (%9.4f)    children %s", this.getPath(), this.fscore, this.forgottenScores == null ? Double.NaN : Arrays.stream(this.forgottenScores).filter(score -> !Double.isNaN(score)).min().orElse(Double.NaN), this.childStates == null ? "(none)" : IntStream.range(0, this.childStates.length).mapToObj(i -> String.format("%d:%s:%.4f:%.4f", new Object[]{i, this.childStates[i], this.forgottenScores[i], this.spawnedChildren[i] == null ? Double.NaN : this.spawnedChildren[i].fscore})).collect(Collectors.toList()));
    }

    private boolean haveAllChildScores() {
        for (State state : this.childStates) {
            if (state != State.Unspawned) continue;
            return false;
        }
        return true;
    }

    public boolean canSpawnChildren() {
        for (State state : this.childStates) {
            if (state != State.Unspawned && state != State.Forgotten) continue;
            return true;
        }
        return false;
    }

    private boolean allChildrenFinished() {
        for (State state : this.childStates) {
            if (state == State.Finished) continue;
            return false;
        }
        return true;
    }

    public boolean hasSpawnedChildren() {
        if (this.childStates == null) {
            return false;
        }
        for (State state : this.childStates) {
            if (state != State.Spawned) continue;
            return true;
        }
        return false;
    }

    public static enum State {
        Unspawned,
        Spawned,
        Finished,
        Forgotten;

    }
}

