/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.conf.scoring.mplp;

import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import java.util.Arrays;

public class MessageVars {
    private RCs rcs;
    private ConfIndex confIndex;
    private double[][] sums;
    private double[][] vars;

    public MessageVars(RCs rcs, ConfIndex confIndex) {
        this(rcs, confIndex, true);
    }

    public MessageVars(RCs rcs, ConfIndex confIndex, boolean usePrecomputedSums) {
        int posi1;
        this.rcs = rcs;
        this.confIndex = confIndex;
        int n = confIndex.numUndefined;
        this.sums = new double[n][];
        for (posi1 = 0; posi1 < n; ++posi1) {
            int pos1 = confIndex.undefinedPos[posi1];
            this.sums[posi1] = new double[rcs.getNum(pos1)];
            if (usePrecomputedSums) {
                Arrays.fill(this.sums[posi1], 0.0);
                continue;
            }
            Arrays.fill(this.sums[posi1], Double.POSITIVE_INFINITY);
        }
        this.vars = new double[n * n][];
        for (posi1 = 0; posi1 < n; ++posi1) {
            for (int posi2 = 0; posi2 < n; ++posi2) {
                int pos2 = confIndex.undefinedPos[posi2];
                int index = this.getNodePairIndex(posi1, posi2);
                this.vars[index] = new double[rcs.getNum(pos2)];
                Arrays.fill(this.vars[index], 0.0);
            }
        }
    }

    public void initTraditionalAStar(EnergyMatrix emat) {
        for (int posi1 = 0; posi1 < this.confIndex.numUndefined; ++posi1) {
            int pos1 = this.confIndex.undefinedPos[posi1];
            for (int rci1 = 0; rci1 < this.rcs.getNum(pos1); ++rci1) {
                int pos2;
                int posi2;
                int rc1 = this.rcs.get(pos1, rci1);
                double sum = emat.getOneBody(pos1, rc1);
                for (posi2 = 0; posi2 < this.confIndex.numDefined; ++posi2) {
                    pos2 = this.confIndex.definedPos[posi2];
                    int rc2 = this.confIndex.definedRCs[posi2];
                    sum += emat.getPairwise(pos1, rc1, pos2, rc2).doubleValue();
                }
                this.set(posi1, posi1, rci1, sum);
                for (posi2 = 0; posi2 < this.confIndex.numUndefined; ++posi2) {
                    pos2 = this.confIndex.undefinedPos[posi2];
                    if (pos2 < pos1) {
                        double minEnergy = Double.POSITIVE_INFINITY;
                        for (int rc2 : this.rcs.get(pos2)) {
                            minEnergy = Math.min(minEnergy, emat.getPairwise(pos1, rc1, pos2, rc2));
                        }
                        this.set(posi2, posi1, rci1, minEnergy);
                        continue;
                    }
                    if (pos2 <= pos1) continue;
                    this.set(posi2, posi1, rci1, 0.0);
                }
                if (!this.canUsePrecomputedSums(posi1, rci1)) continue;
                sum = 0.0;
                for (posi2 = 0; posi2 < this.confIndex.numUndefined; ++posi2) {
                    sum += this.get(posi2, posi1, rci1);
                }
                this.sums[posi1][rci1] = sum;
            }
        }
    }

    public RCs getRCs() {
        return this.rcs;
    }

    public ConfIndex getConfIndex() {
        return this.confIndex;
    }

    private boolean canUsePrecomputedSums(int posi, int rci) {
        return Double.isFinite(this.sums[posi][rci]);
    }

    private boolean canUsePrecomputedSums(int posi, int rci, double val) {
        return this.canUsePrecomputedSums(posi, rci) && Double.isFinite(val);
    }

    public double get(int posi1, int posi2, int rci2) {
        return this.vars[this.getNodePairIndex(posi1, posi2)][rci2];
    }

    public void set(int posi1, int posi2, int rci2, double val) {
        if (Double.isNaN(val)) {
            throw new IllegalArgumentException("val shouldn't be NaN");
        }
        if (val == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException("val shouldn't be -inf");
        }
        int index = this.getNodePairIndex(posi1, posi2);
        if (this.canUsePrecomputedSums(posi2, rci2, val)) {
            double[] dArray = this.sums[posi2];
            int n = rci2;
            dArray[n] = dArray[n] - this.vars[index][rci2];
            double[] dArray2 = this.sums[posi2];
            int n2 = rci2;
            dArray2[n2] = dArray2[n2] + val;
        } else {
            this.sums[posi2][rci2] = Double.POSITIVE_INFINITY;
        }
        this.vars[index][rci2] = val;
    }

    public double getEnergy(int posi1, int rci1) {
        if (this.canUsePrecomputedSums(posi1, rci1)) {
            return this.sums[posi1][rci1];
        }
        double sum = 0.0;
        for (int posi2 = 0; posi2 < this.confIndex.numUndefined; ++posi2) {
            sum += this.vars[this.getNodePairIndex(posi2, posi1)][rci1];
        }
        return sum;
    }

    public double getEnergyWithout(int posi1, int rci1, int posi2Out) {
        if (this.canUsePrecomputedSums(posi1, rci1)) {
            return this.getEnergy(posi1, rci1) - this.get(posi2Out, posi1, rci1);
        }
        double sum = 0.0;
        for (int posi2 = 0; posi2 < this.confIndex.numUndefined; ++posi2) {
            if (posi2 == posi2Out) continue;
            sum += this.vars[this.getNodePairIndex(posi2, posi1)][rci1];
        }
        return sum;
    }

    public double getTotalEnergy() {
        double energy = 0.0;
        for (int posi1 = 0; posi1 < this.confIndex.numUndefined; ++posi1) {
            int pos1 = this.confIndex.undefinedPos[posi1];
            double minPosEnergy = Double.POSITIVE_INFINITY;
            for (int rci1 = 0; rci1 < this.rcs.getNum(pos1); ++rci1) {
                minPosEnergy = Math.min(minPosEnergy, this.getEnergy(posi1, rci1));
            }
            energy += minPosEnergy;
        }
        return energy;
    }

    private int getNodePairIndex(int posi1, int posi2) {
        return posi1 * this.confIndex.numUndefined + posi2;
    }
}

