/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.conf.linked;

import edu.duke.cs.osprey.astar.conf.ConfAStarNode;
import edu.duke.cs.osprey.astar.conf.ConfIndex;
import java.util.Arrays;

public class LinkedConfAStarNode
implements ConfAStarNode {
    private short level;
    private Link link;
    private double gscore;
    private double hscore;

    private LinkedConfAStarNode(int level, Link link) {
        assert (level <= Short.MAX_VALUE);
        this.level = (short)level;
        this.link = link;
        this.gscore = Double.NaN;
        this.hscore = Double.NaN;
    }

    public LinkedConfAStarNode() {
        this(0, new Link());
    }

    @Override
    public LinkedConfAStarNode assign(int pos, int rc) {
        return new LinkedConfAStarNode(this.level + 1, new Link(this.link, pos, rc));
    }

    public Link getLink() {
        return this.link;
    }

    @Override
    public void getConf(int[] conf) {
        Arrays.fill(conf, -1);
        Link link = this.link;
        while (!link.isRoot()) {
            conf[link.getPos()] = link.getRC();
            link = link.getParent();
        }
    }

    @Override
    public double getGScore() {
        return this.gscore;
    }

    @Override
    public void setGScore(double val) {
        this.gscore = val;
    }

    @Override
    public double getHScore() {
        return this.hscore;
    }

    @Override
    public void setHScore(double val) {
        this.hscore = val;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void index(ConfIndex index) {
        int i;
        if (index.node == this) {
            return;
        }
        index.node = this;
        int numPos = index.numPos;
        int numDefined = 0;
        int[] dpos = index.definedPos;
        int[] rcs = index.definedRCs;
        int numUndefined = 0;
        int[] upos = index.undefinedPos;
        Link link = this.link;
        while (!link.isRoot()) {
            dpos[numDefined] = link.getPos();
            rcs[numDefined] = link.getRC();
            ++numDefined;
            link = link.getParent();
        }
        for (i = 1; i < numDefined; ++i) {
            int tempPos = dpos[i];
            int tempRC = rcs[i];
            for (int j = i; j >= 1 && tempPos < dpos[j - 1]; --j) {
                dpos[j] = dpos[j - 1];
                rcs[j] = rcs[j - 1];
            }
            dpos[j] = tempPos;
            rcs[j] = tempRC;
        }
        if (numDefined == 0) {
            numUndefined = numPos;
            for (int pos = 0; pos < numPos; ++pos) {
                upos[pos] = pos;
            }
        } else {
            i = 0;
            for (int pos = 0; pos < numPos; ++pos) {
                if (i < numDefined && pos == dpos[i]) {
                    ++i;
                    continue;
                }
                upos[numUndefined] = pos;
                ++numUndefined;
            }
        }
        assert (numDefined + numUndefined == numPos);
        index.numDefined = numDefined;
        index.numUndefined = numUndefined;
    }

    public static class Link
    implements Comparable<Link> {
        private Link parent;
        private short pos;
        private short rc;

        public Link() {
            this(null, -1, -1);
        }

        public Link(Link parent, int pos, int rc) {
            assert (pos <= Short.MAX_VALUE);
            assert (rc <= Short.MAX_VALUE);
            this.parent = parent;
            this.pos = (short)pos;
            this.rc = (short)rc;
        }

        public Link getParent() {
            return this.parent;
        }

        public int getPos() {
            return this.pos;
        }

        public int getRC() {
            return this.rc;
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        @Override
        public int compareTo(Link other) {
            return this.pos - other.pos;
        }
    }
}

