/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class Cleaner {
    private static ReferenceQueue<GarbageDetectable> refQueue = new ReferenceQueue();
    private static MultiValuedMap<PhantomReference<GarbageDetectable>, Cleanable> cleanables = new ArrayListValuedHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Cleanable> T addCleaner(GarbageDetectable thing, T cleanable) {
        if (thing == cleanable) {
            throw new IllegalArgumentException("GarbageDetectable instance and Cleanable instance must be different objects");
        }
        try {
            thing.getClass().getDeclaredMethod("finalize", new Class[0]);
            throw new IllegalArgumentException("GarbageDetectable instance cannot have a finalizer method");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            MultiValuedMap<PhantomReference<GarbageDetectable>, Cleanable> multiValuedMap = cleanables;
            synchronized (multiValuedMap) {
                cleanables.put(new PhantomReference<GarbageDetectable>(thing, refQueue), cleanable);
            }
            return cleanable;
        }
    }

    public static void main(String[] args) throws Exception {
        ExampleThing thing = new ExampleThing();
        thing.cleanup();
        thing = null;
        thing = new ExampleThing();
        thing = null;
        System.out.println("waiting for cleanup...");
        System.gc();
        Thread.sleep(400L);
        System.out.println("done");
    }

    static {
        Thread thread2 = new Thread(() -> {
            try {
                ArrayList refCleanables = new ArrayList();
                while (true) {
                    Reference<GarbageDetectable> ref = refQueue.remove();
                    ref.clear();
                    refCleanables.clear();
                    MultiValuedMap<PhantomReference<GarbageDetectable>, Cleanable> multiValuedMap = cleanables;
                    synchronized (multiValuedMap) {
                        refCleanables.addAll(cleanables.remove(ref));
                    }
                    for (Cleanable refCleanable : refCleanables) {
                        refCleanable.clean();
                    }
                    refCleanables.clear();
                }
            }
            catch (InterruptedException ex) {
                throw new Error(ex);
            }
        }, "Cleaner");
        thread2.setDaemon(true);
        thread2.start();
    }

    public static interface GarbageDetectable {
    }

    public static class ExampleThing
    implements GarbageDetectable {
        private ExampleResource resource;

        public ExampleThing() {
            System.out.println("Thing()");
            this.resource = Cleaner.addCleaner(this, new ExampleResource());
        }

        public void cleanup() {
            System.out.println("Thing.cleanup()");
            this.resource.clean();
        }
    }

    public static interface Cleanable {
        public void clean();
    }

    public static class ExampleResource
    implements Cleanable {
        public boolean isUsing;

        public ExampleResource() {
            System.out.println("Resource()   " + System.identityHashCode(this));
            this.isUsing = true;
        }

        @Override
        public void clean() {
            if (this.isUsing) {
                System.out.println("Resource.cleanup()   " + System.identityHashCode(this));
                this.isUsing = false;
            }
        }
    }
}

