/*
 * Decompiled with CFR 0.152.
 */
package smile.netlib;

import com.github.fommil.netlib.LAPACK;
import org.netlib.util.intW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.Math;
import smile.math.matrix.Cholesky;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.Matrix;
import smile.netlib.NLMatrix;

public class QR
extends smile.math.matrix.QR {
    private static final Logger logger = LoggerFactory.getLogger(QR.class);

    public QR(DenseMatrix qr, double[] tau, boolean singular) {
        super(qr, tau, singular);
    }

    public Cholesky CholeskyOfAtA() {
        int n = this.qr.ncols();
        DenseMatrix L = Matrix.zeros((int)n, (int)n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                L.set(i, j, this.qr.get(j, i));
            }
        }
        return new Cholesky(L);
    }

    public DenseMatrix getR() {
        int m = this.qr.nrows();
        int n = this.qr.ncols();
        DenseMatrix R = Matrix.zeros((int)m, (int)n);
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                R.set(i, j, this.qr.get(i, j));
            }
        }
        return R;
    }

    public DenseMatrix getQ() {
        int m = this.qr.nrows();
        int n = this.qr.ncols();
        int k = Math.min((int)m, (int)n);
        intW info = new intW(0);
        double[] work = new double[1];
        LAPACK.getInstance().dorgqr(m, n, k, this.qr.data(), this.qr.ld(), this.tau, work, -1, info);
        int lwork = n;
        if (info.val == 0) {
            lwork = (int)work[0];
            logger.debug("LAPACK DORGQR returns work space size: {}", (Object)lwork);
        } else {
            logger.warn("LAPACK DORGQR error code: {}", (Object)info.val);
        }
        lwork = Math.max((int)1, (int)lwork);
        work = new double[lwork];
        info.val = 0;
        LAPACK.getInstance().dorgqr(m, n, k, this.qr.data(), this.qr.ld(), this.tau, work, lwork, info);
        if (info.val < 0) {
            logger.error("LAPACK DORGQR error code: {}", (Object)info.val);
            throw new IllegalArgumentException("LAPACK DORGQR error code: " + info.val);
        }
        return this.qr;
    }

    public void solve(double[] b, double[] x) {
        if (b.length != this.qr.nrows()) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but B is %d x 1", this.qr.nrows(), this.qr.nrows(), b.length));
        }
        if (x.length != this.qr.ncols()) {
            throw new IllegalArgumentException("A and x dimensions don't match.");
        }
        if (this.singular) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        double[] B = (double[])b.clone();
        this.solve(Matrix.newInstance((double[])B));
        System.arraycopy(B, 0, x, 0, x.length);
    }

    public void solve(DenseMatrix B) {
        if (B.nrows() != this.qr.nrows()) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but B is %d x %d", this.qr.nrows(), this.qr.nrows(), B.nrows(), B.ncols()));
        }
        if (this.singular) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        int m = this.qr.nrows();
        int n = this.qr.ncols();
        int k = Math.min((int)m, (int)n);
        intW info = new intW(0);
        double[] work = new double[1];
        LAPACK.getInstance().dormqr(NLMatrix.Left, NLMatrix.Transpose, B.nrows(), B.ncols(), k, this.qr.data(), this.qr.ld(), this.tau, B.data(), B.ld(), work, -1, info);
        int lwork = n;
        if (info.val == 0) {
            lwork = (int)work[0];
            logger.debug("LAPACK DORMQR returns work space size: {}", (Object)lwork);
        } else {
            logger.warn("LAPACK DORMQR error code: {}", (Object)info.val);
        }
        lwork = Math.max((int)1, (int)lwork);
        work = new double[lwork];
        info.val = 0;
        LAPACK.getInstance().dormqr(NLMatrix.Left, NLMatrix.Transpose, B.nrows(), B.ncols(), k, this.qr.data(), this.qr.ld(), this.tau, B.data(), B.ld(), work, lwork, info);
        if (info.val < 0) {
            logger.error("LAPACK DORMQR error code: {}", (Object)info.val);
            throw new IllegalArgumentException("LAPACK DORMQR error code: " + info.val);
        }
        info.val = 0;
        LAPACK.getInstance().dtrtrs(NLMatrix.Upper, NLMatrix.NoTranspose, NLMatrix.NonUnitTriangular, this.qr.ncols(), B.ncols(), this.qr.data(), this.qr.ld(), B.data(), B.ld(), info);
        if (info.val != 0) {
            logger.error("LAPACK DTRTRS error code: {}", (Object)info.val);
            throw new IllegalArgumentException("LAPACK DTRTRS error code: " + info.val);
        }
    }
}

