/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.Math;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.Factory;
import smile.math.matrix.Lanczos;
import smile.math.matrix.SVD;
import smile.stat.distribution.GaussianDistribution;

public abstract class Matrix
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(Matrix.class);
    private boolean symmetric = false;

    public static DenseMatrix newInstance(double[][] A) {
        return Factory.matrix(A);
    }

    public static DenseMatrix newInstance(double[] A) {
        return Factory.matrix(A);
    }

    public static DenseMatrix newInstance(int rows, int cols, double value) {
        return Factory.matrix(rows, cols, value);
    }

    public static DenseMatrix zeros(int rows, int cols) {
        return Factory.matrix(rows, cols);
    }

    public static DenseMatrix ones(int rows, int cols) {
        return Factory.matrix(rows, cols, 1.0);
    }

    public static DenseMatrix eye(int n) {
        DenseMatrix matrix = Factory.matrix(n, n);
        for (int i = 0; i < n; ++i) {
            matrix.set(i, i, 1.0);
        }
        return matrix;
    }

    public static DenseMatrix eye(int m, int n) {
        DenseMatrix matrix = Factory.matrix(m, n);
        int k = Math.min(m, n);
        for (int i = 0; i < k; ++i) {
            matrix.set(i, i, 1.0);
        }
        return matrix;
    }

    public static DenseMatrix diag(double[] A) {
        int n = A.length;
        DenseMatrix matrix = Factory.matrix(n, n);
        for (int i = 0; i < n; ++i) {
            matrix.set(i, i, A[i]);
        }
        return matrix;
    }

    public static DenseMatrix randn(int rows, int cols) {
        return Matrix.randn(rows, cols, 0.0, 1.0);
    }

    public static DenseMatrix randn(int rows, int cols, double mu, double sigma) {
        DenseMatrix a = Matrix.zeros(rows, cols);
        GaussianDistribution g = new GaussianDistribution(mu, sigma);
        for (int j = 0; j < cols; ++j) {
            for (int i = 0; i < rows; ++i) {
                a.set(i, j, g.rand());
            }
        }
        return a;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean full) {
        StringBuilder sb = new StringBuilder();
        int m = full ? this.nrows() : Math.min(7, this.nrows());
        int n = full ? this.ncols() : Math.min(7, this.ncols());
        String newline = n < this.ncols() ? "...\n" : "\n";
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                sb.append(String.format("%8.4f  ", this.get(i, j)));
            }
            sb.append(newline);
        }
        if (m < this.nrows()) {
            sb.append("  ...\n");
        }
        return sb.toString();
    }

    public boolean isSymmetric() {
        return this.symmetric;
    }

    public void setSymmetric(boolean symmetric) {
        this.symmetric = symmetric;
    }

    public abstract int nrows();

    public abstract int ncols();

    public abstract Matrix transpose();

    public abstract double get(int var1, int var2);

    public double apply(int i, int j) {
        return this.get(i, j);
    }

    public double[] diag() {
        int n = Math.min(this.nrows(), this.ncols());
        double[] d = new double[n];
        for (int i = 0; i < n; ++i) {
            d[i] = this.get(i, i);
        }
        return d;
    }

    public double trace() {
        int n = Math.min(this.nrows(), this.ncols());
        double t = 0.0;
        for (int i = 0; i < n; ++i) {
            t += this.get(i, i);
        }
        return t;
    }

    public abstract Matrix ata();

    public abstract Matrix aat();

    public abstract double[] ax(double[] var1, double[] var2);

    public abstract double[] axpy(double[] var1, double[] var2);

    public abstract double[] axpy(double[] var1, double[] var2, double var3);

    public abstract double[] atx(double[] var1, double[] var2);

    public abstract double[] atxpy(double[] var1, double[] var2);

    public abstract double[] atxpy(double[] var1, double[] var2, double var3);

    public EVD eigen(int k) {
        return this.eigen(k, 1.0E-8, 10 * this.nrows());
    }

    public EVD eigen(int k, double kappa, int maxIter) {
        try {
            Class<?> clazz = Class.forName("smile.netlib.ARPACK");
            Method method = clazz.getMethod("eigen", Matrix.class, Integer.TYPE, String.class, Double.TYPE, Integer.TYPE);
            return (EVD)method.invoke(null, this, k, "LA", kappa, maxIter);
        }
        catch (Exception e) {
            if (!(e instanceof ClassNotFoundException)) {
                logger.info("Matrix.eigen({}, {}, {}):", new Object[]{k, kappa, maxIter, e});
            }
            return Lanczos.eigen(this, k, kappa, maxIter);
        }
    }

    public SVD svd(int k) {
        return this.svd(k, 1.0E-8, 10 * this.nrows());
    }

    public SVD svd(int k, double kappa, int maxIter) {
        int n;
        ATA B = new ATA(this);
        EVD eigen = Lanczos.eigen(B, k, kappa, maxIter);
        double[] s = eigen.getEigenValues();
        for (int i = 0; i < s.length; ++i) {
            s[i] = Math.sqrt(s[i]);
        }
        int m = this.nrows();
        if (m >= (n = this.ncols())) {
            DenseMatrix V = eigen.getEigenVectors();
            double[] tmp = new double[m];
            double[] vi = new double[n];
            DenseMatrix U = Matrix.zeros(m, s.length);
            for (int i = 0; i < s.length; ++i) {
                int j;
                for (j = 0; j < n; ++j) {
                    vi[j] = V.get(j, i);
                }
                this.ax(vi, tmp);
                for (j = 0; j < m; ++j) {
                    U.set(j, i, tmp[j] / s[i]);
                }
            }
            return new SVD(U, V, s);
        }
        DenseMatrix U = eigen.getEigenVectors();
        double[] tmp = new double[n];
        double[] ui = new double[m];
        DenseMatrix V = Matrix.zeros(n, s.length);
        for (int i = 0; i < s.length; ++i) {
            int j;
            for (j = 0; j < m; ++j) {
                ui[j] = U.get(j, i);
            }
            this.atx(ui, tmp);
            for (j = 0; j < n; ++j) {
                V.set(j, i, tmp[j] / s[i]);
            }
        }
        return new SVD(U, V, s);
    }

    private static class ATA
    extends Matrix {
        Matrix A;
        Matrix AtA;
        double[] buf;

        public ATA(Matrix A) {
            this.A = A;
            this.setSymmetric(true);
            if (A.nrows() >= A.ncols()) {
                this.buf = new double[A.nrows()];
                if (A.ncols() < 10000 && A instanceof DenseMatrix) {
                    this.AtA = A.ata();
                }
            } else {
                this.buf = new double[A.ncols()];
                if (A.nrows() < 10000 && A instanceof DenseMatrix) {
                    this.AtA = A.aat();
                }
            }
        }

        @Override
        public int nrows() {
            if (this.A.nrows() >= this.A.ncols()) {
                return this.A.ncols();
            }
            return this.A.nrows();
        }

        @Override
        public int ncols() {
            return this.nrows();
        }

        @Override
        public ATA transpose() {
            return this;
        }

        @Override
        public ATA ata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ATA aat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double[] ax(double[] x, double[] y) {
            if (this.AtA != null) {
                this.AtA.ax(x, y);
            } else if (this.A.nrows() >= this.A.ncols()) {
                this.A.ax(x, this.buf);
                this.A.atx(this.buf, y);
            } else {
                this.A.atx(x, this.buf);
                this.A.ax(this.buf, y);
            }
            return y;
        }

        @Override
        public double[] atx(double[] x, double[] y) {
            return this.ax(x, y);
        }

        @Override
        public double[] axpy(double[] x, double[] y) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double[] axpy(double[] x, double[] y, double b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double get(int i, int j) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double apply(int i, int j) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double[] atxpy(double[] x, double[] y) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double[] atxpy(double[] x, double[] y, double b) {
            throw new UnsupportedOperationException();
        }
    }
}

