/*
 * Decompiled with CFR 0.152.
 */
package smile.wavelet;

import smile.math.Math;
import smile.wavelet.Wavelet;

public class WaveletShrinkage {
    public static void denoise(double[] t, Wavelet wavelet) {
        WaveletShrinkage.denoise(t, wavelet, false);
    }

    public static void denoise(double[] t, Wavelet wavelet, boolean soft) {
        wavelet.transform(t);
        int n = t.length;
        int nh = t.length >> 1;
        double[] wc = new double[nh];
        System.arraycopy(t, nh, wc, 0, nh);
        double error = Math.mad((double[])wc) / 0.6745;
        double lambda = error * Math.sqrt((double)(2.0 * Math.log((double)n)));
        if (soft) {
            for (int i = 2; i < n; ++i) {
                t[i] = Math.signum((double)t[i]) * Math.max((double)(Math.abs((double)t[i]) - lambda), (double)0.0);
            }
        } else {
            for (int i = 2; i < n; ++i) {
                if (!(Math.abs((double)t[i]) < lambda)) continue;
                t[i] = 0.0;
            }
        }
        wavelet.inverse(t);
    }
}

