/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import smile.math.Math;

public class CrossValidation {
    public final int k;
    public final int[][] train;
    public final int[][] test;

    public CrossValidation(int n, int k) {
        this(n, k, true);
    }

    public CrossValidation(int n, int k, boolean permutate) {
        int[] index;
        if (n < 0) {
            throw new IllegalArgumentException("Invalid sample size: " + n);
        }
        if (k < 0 || k > n) {
            throw new IllegalArgumentException("Invalid number of CV rounds: " + k);
        }
        this.k = k;
        if (permutate) {
            index = Math.permutate((int)n);
        } else {
            index = new int[n];
            for (int i = 0; i < n; ++i) {
                index[i] = i;
            }
        }
        this.train = new int[k][];
        this.test = new int[k][];
        int chunk = n / k;
        for (int i = 0; i < k; ++i) {
            int start = chunk * i;
            int end = chunk * (i + 1);
            if (i == k - 1) {
                end = n;
            }
            this.train[i] = new int[n - end + start];
            this.test[i] = new int[end - start];
            int p = 0;
            int q = 0;
            for (int j = 0; j < n; ++j) {
                if (j >= start && j < end) {
                    this.test[i][p++] = index[j];
                    continue;
                }
                this.train[i][q++] = index[j];
            }
        }
    }
}

