/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import smile.math.IntArrayList;
import smile.math.Math;
import smile.neighbor.KNNSearch;
import smile.neighbor.NearestNeighborSearch;
import smile.neighbor.Neighbor;
import smile.neighbor.RNNSearch;
import smile.sort.HeapSelect;
import smile.stat.distribution.GaussianDistribution;

public class LSH<E>
implements NearestNeighborSearch<double[], E>,
KNNSearch<double[], E>,
RNNSearch<double[], E> {
    final int P = Integer.MAX_VALUE;
    final int MAX_HASH_RND = 0x20000000;
    ArrayList<double[]> keys;
    ArrayList<E> data;
    List<Hash> hash;
    int H;
    int d;
    int L;
    int k;
    double w;
    int[] r1;
    int[] r2;
    boolean identicalExcluded = true;

    public LSH(double[][] keys, E[] data) {
        this(keys, data, 4.0);
    }

    public LSH(double[][] keys, E[] data, double w) {
        this(keys, data, w, keys.length);
    }

    public LSH(double[][] keys, E[] data, double w, int H) {
        this(keys[0].length, Math.max((int)50, (int)((int)Math.pow((double)keys.length, (double)0.25))), Math.max((int)3, (int)((int)Math.log10((double)keys.length))), w, H);
        if (keys.length != data.length) {
            throw new IllegalArgumentException("The array size of keys and data are different.");
        }
        if (H < keys.length) {
            throw new IllegalArgumentException("Hash table size is too small: " + H);
        }
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            this.put(keys[i], data[i]);
        }
    }

    public LSH(int d, int L, int k) {
        this(d, L, k, 4.0);
    }

    public LSH(int d, int L, int k, double w) {
        this(d, L, k, w, 1017881);
    }

    public LSH(int d, int L, int k, double w, int H) {
        int i;
        if (d < 2) {
            throw new IllegalArgumentException("Invalid input space dimension: " + d);
        }
        if (L < 1) {
            throw new IllegalArgumentException("Invalid number of hash tables: " + L);
        }
        if (k < 1) {
            throw new IllegalArgumentException("Invalid number of random projections per hash value: " + k);
        }
        if (w <= 0.0) {
            throw new IllegalArgumentException("Invalid width of random projections: " + w);
        }
        if (H < 1) {
            throw new IllegalArgumentException("Invalid size of hash tables: " + H);
        }
        this.d = d;
        this.L = L;
        this.k = k;
        this.w = w;
        this.H = H;
        this.keys = new ArrayList();
        this.data = new ArrayList();
        this.r1 = new int[k];
        this.r2 = new int[k];
        for (i = 0; i < k; ++i) {
            this.r1[i] = Math.randomInt((int)0x20000000);
            this.r2[i] = Math.randomInt((int)0x20000000);
        }
        this.hash = new ArrayList<Hash>(L);
        for (i = 0; i < L; ++i) {
            this.hash.add(new Hash());
        }
    }

    public String toString() {
        return String.format("LSH (L=%d, k=%d, H=%d, w=%.4f)", this.hash.size(), this.k, this.H, this.w);
    }

    public boolean isIdenticalExcluded() {
        return this.identicalExcluded;
    }

    public LSH<E> setIdenticalExcluded(boolean excluded) {
        this.identicalExcluded = excluded;
        return this;
    }

    public void put(double[] key, E value) {
        int index = this.keys.size();
        this.keys.add(key);
        this.data.add(value);
        for (Hash h : this.hash) {
            h.add(index, key);
        }
    }

    @Override
    public Neighbor<double[], E> nearest(double[] q) {
        Set<Integer> candidates = this.obtainCandidates(q);
        Neighbor<Object, Object> neighbor = new Neighbor<Object, Object>(null, null, -1, Double.MAX_VALUE);
        for (int index : candidates) {
            double distance;
            double[] key = this.keys.get(index);
            if (q == key && this.identicalExcluded || !((distance = Math.distance((double[])q, (double[])key)) < neighbor.distance)) continue;
            neighbor.index = index;
            neighbor.distance = distance;
            neighbor.key = key;
            neighbor.value = this.data.get(index);
        }
        return neighbor;
    }

    @Override
    public Neighbor<double[], E>[] knn(double[] q, int k) {
        if (k < 1) {
            throw new IllegalArgumentException("Invalid k: " + k);
        }
        Set<Integer> candidates = this.obtainCandidates(q);
        Neighbor<Object, Object> neighbor = new Neighbor<Object, Object>(null, null, 0, Double.MAX_VALUE);
        Comparable[] neighbors = (Neighbor[])Array.newInstance(neighbor.getClass(), k);
        HeapSelect heap = new HeapSelect(neighbors);
        for (int i = 0; i < k; ++i) {
            heap.add(neighbor);
        }
        int hit = 0;
        for (int index : candidates) {
            double distance;
            double[] key = this.keys.get(index);
            if (q == key && this.identicalExcluded || !((distance = Math.distance((double[])q, (double[])key)) < ((Neighbor)heap.peek()).distance)) continue;
            heap.add(new Neighbor<double[], E>(key, this.data.get(index), index, distance));
            ++hit;
        }
        heap.sort();
        if (hit < k) {
            Neighbor[] n2 = (Neighbor[])Array.newInstance(neighbor.getClass(), hit);
            int start = k - hit;
            for (int i = 0; i < hit; ++i) {
                n2[i] = neighbors[i + start];
            }
            neighbors = n2;
        }
        return neighbors;
    }

    @Override
    public void range(double[] q, double radius, List<Neighbor<double[], E>> neighbors) {
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Invalid radius: " + radius);
        }
        Set<Integer> candidates = this.obtainCandidates(q);
        for (int index : candidates) {
            double distance;
            double[] key = this.keys.get(index);
            if (q == key && this.identicalExcluded || !((distance = Math.distance((double[])q, (double[])key)) <= radius)) continue;
            neighbors.add(new Neighbor<double[], E>(key, this.data.get(index), index, distance));
        }
    }

    private Set<Integer> obtainCandidates(double[] q) {
        LinkedHashSet<Integer> candidates = new LinkedHashSet<Integer>();
        for (Hash h : this.hash) {
            BucketEntry bucket = h.get(q);
            if (bucket == null) continue;
            int m = bucket.entry.size();
            for (int i = 0; i < m; ++i) {
                int index = bucket.entry.get(i);
                candidates.add(index);
            }
        }
        return candidates;
    }

    class Hash {
        double[][] a;
        double[] b;
        HashEntry[] table;

        Hash() {
            this.a = new double[LSH.this.k][LSH.this.d];
            this.b = new double[LSH.this.k];
            GaussianDistribution gaussian = GaussianDistribution.getInstance();
            for (int i = 0; i < LSH.this.k; ++i) {
                for (int j = 0; j < LSH.this.d; ++j) {
                    this.a[i][j] = gaussian.rand();
                }
                this.b[i] = Math.random((double)0.0, (double)LSH.this.w);
            }
            this.table = new HashEntry[LSH.this.H];
        }

        int hash(double[] x, int m) {
            double g = this.b[m];
            for (int j = 0; j < LSH.this.d; ++j) {
                g += this.a[m][j] * x[j];
            }
            int h = (int)Math.floor((double)(g / LSH.this.w));
            if (h < 0) {
                h += Integer.MAX_VALUE;
            }
            return h;
        }

        int hash(int[] r, double[] x) {
            long g = 0L;
            for (int i = 0; i < LSH.this.k; ++i) {
                g += (long)(r[i] * this.hash(x, i));
            }
            int h = (int)(g % Integer.MAX_VALUE);
            if (h < 0) {
                h += Integer.MAX_VALUE;
            }
            return h;
        }

        void add(int index, double[] x) {
            int bucket = this.hash(LSH.this.r2, x);
            int i = this.hash(LSH.this.r1, x) % LSH.this.H;
            if (this.table[i] == null) {
                this.table[i] = new HashEntry();
            }
            this.table[i].add(bucket, index);
        }

        BucketEntry get(double[] x) {
            int bucket = this.hash(LSH.this.r2, x);
            int i = this.hash(LSH.this.r1, x) % LSH.this.H;
            HashEntry he = this.table[i];
            if (he == null) {
                return null;
            }
            for (BucketEntry be : he.entry) {
                if (bucket != be.bucket) continue;
                return be;
            }
            return null;
        }
    }

    static class HashEntry {
        List<BucketEntry> entry = new LinkedList<BucketEntry>();

        HashEntry() {
        }

        void add(int bucket, int point) {
            for (BucketEntry b : this.entry) {
                if (b.bucket != bucket) continue;
                b.add(point);
                return;
            }
            BucketEntry b = new BucketEntry(bucket);
            b.add(point);
            this.entry.add(b);
        }

        boolean remove(int bucket, int point) {
            for (BucketEntry b : this.entry) {
                if (b.bucket != bucket) continue;
                return b.remove(point);
            }
            return false;
        }
    }

    static class BucketEntry {
        int bucket;
        IntArrayList entry;

        BucketEntry(int bucket) {
            this.bucket = bucket;
            this.entry = new IntArrayList();
        }

        void add(int point) {
            this.entry.add(point);
        }

        boolean remove(int point) {
            int n = this.entry.size();
            for (int i = 0; i < n; ++i) {
                if (this.entry.get(i) != point) continue;
                this.entry.remove(i);
                return true;
            }
            return false;
        }
    }
}

