/*
 * Decompiled with CFR 0.152.
 */
package smile.mds;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.Math;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.Matrix;

public class MDS {
    private static final Logger logger = LoggerFactory.getLogger(MDS.class);
    private double[] eigenvalues;
    private double[][] coordinates;
    private double[] proportion;

    public double[] getEigenValues() {
        return this.eigenvalues;
    }

    public double[] getProportion() {
        return this.proportion;
    }

    public double[][] getCoordinates() {
        return this.coordinates;
    }

    public MDS(double[][] proximity) {
        this(proximity, 2);
    }

    public MDS(double[][] proximity, int k) {
        this(proximity, k, false);
    }

    public MDS(double[][] proximity, int k, boolean add) {
        int i;
        int m = proximity.length;
        int n = proximity[0].length;
        if (m != n) {
            throw new IllegalArgumentException("The proximity matrix is not square.");
        }
        if (k < 1 || k >= n) {
            throw new IllegalArgumentException("Invalid k = " + k);
        }
        DenseMatrix A = Matrix.zeros((int)n, (int)n);
        DenseMatrix B = Matrix.zeros((int)n, (int)n);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int j = 0; j < i2; ++j) {
                double x = -0.5 * Math.sqr((double)proximity[i2][j]);
                A.set(i2, j, x);
                A.set(j, i2, x);
            }
        }
        double[] mean = A.rowMeans();
        double mu = Math.mean((double[])mean);
        for (int i3 = 0; i3 < n; ++i3) {
            for (int j = 0; j <= i3; ++j) {
                double x = A.get(i3, j) - mean[i3] - mean[j] + mu;
                B.set(i3, j, x);
                B.set(j, i3, x);
            }
        }
        if (add) {
            int i4;
            DenseMatrix Z = Matrix.zeros((int)(2 * n), (int)(2 * n));
            for (i4 = 0; i4 < n; ++i4) {
                for (int j = 0; j < n; ++j) {
                    Z.set(i4, n + j, 2.0 * B.get(i4, j));
                }
            }
            for (i4 = 0; i4 < n; ++i4) {
                Z.set(n + i4, i4, -1.0);
            }
            mean = Math.rowMeans((double[][])proximity);
            mu = Math.mean((double[])mean);
            for (i4 = 0; i4 < n; ++i4) {
                for (int j = 0; j < n; ++j) {
                    Z.set(n + i4, n + j, 2.0 * (proximity[i4][j] - mean[i4] - mean[j] + mu));
                }
            }
            double[] evalues = Z.eig();
            double c = Math.max((double[])evalues);
            for (i = 0; i < n; ++i) {
                B.set(i, i, 0.0);
                for (int j = 0; j < i; ++j) {
                    double x = -0.5 * Math.sqr((double)(proximity[i][j] + c));
                    B.set(i, j, x);
                    B.set(j, i, x);
                }
            }
        }
        B.setSymmetric(true);
        EVD eigen = B.eigen(k);
        if (eigen.getEigenValues().length < k) {
            logger.warn("eigen({}) returns only {} eigen vectors", (Object)k, (Object)eigen.getEigenValues().length);
            k = eigen.getEigenValues().length;
        }
        this.coordinates = new double[n][k];
        for (int j = 0; j < k; ++j) {
            if (eigen.getEigenValues()[j] < 0.0) {
                throw new IllegalArgumentException(String.format("Some of the first %d eigenvalues are < 0.", k));
            }
            double scale = Math.sqrt((double)eigen.getEigenValues()[j]);
            for (i = 0; i < n; ++i) {
                this.coordinates[i][j] = eigen.getEigenVectors().get(i, j) * scale;
            }
        }
        this.eigenvalues = eigen.getEigenValues();
        this.proportion = (double[])this.eigenvalues.clone();
        Math.unitize1((double[])this.proportion);
    }
}

