/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import smile.data.Attribute;
import smile.feature.Scaler;
import smile.math.Math;
import smile.sort.QuickSelect;

public class WinsorScaler
extends Scaler {
    protected double lower;
    protected double upper;

    public WinsorScaler(double lower, double upper) {
        if (lower < 0.0 || lower > 0.5) {
            throw new IllegalArgumentException("Invalid lower limit: " + lower);
        }
        if (upper < 0.5 || upper > 1.0) {
            throw new IllegalArgumentException("Invalid upper limit: " + upper);
        }
        if (upper <= lower) {
            throw new IllegalArgumentException("Invalid lower and upper limit pair: " + lower + " >= " + upper);
        }
        this.lower = lower;
        this.upper = upper;
    }

    public WinsorScaler(double lower, double upper, boolean copy) {
        super(copy);
        if (lower < 0.0 || lower > 0.5) {
            throw new IllegalArgumentException("Invalid lower limit: " + lower);
        }
        if (upper < 0.5 || upper > 1.0) {
            throw new IllegalArgumentException("Invalid upper limit: " + upper);
        }
        if (upper <= lower) {
            throw new IllegalArgumentException("Invalid lower and upper limit pair: " + lower + " >= " + upper);
        }
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public void learn(Attribute[] attributes, double[][] data) {
        int n = data.length;
        int p = data[0].length;
        int i1 = (int)Math.round((double)(this.lower * (double)n));
        int i2 = (int)Math.round((double)(this.upper * (double)n));
        if (i2 == n) {
            i2 = n - 1;
        }
        this.lo = new double[p];
        this.hi = new double[p];
        double[] x = new double[n];
        for (int j = 0; j < p; ++j) {
            if (attributes[j].getType() != Attribute.Type.NUMERIC) {
                this.lo[j] = Double.NaN;
                continue;
            }
            for (int i = 0; i < n; ++i) {
                x[i] = data[i][j];
            }
            this.lo[j] = QuickSelect.select((double[])x, (int)i1);
            this.hi[j] = QuickSelect.select((double[])x, (int)i2) - this.lo[j];
            if (!Math.isZero((double)this.hi[j])) continue;
            throw new IllegalArgumentException("Attribute " + j + " has constant values in the given range.");
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("WinsorScaler(%f, %f", this.lower, this.upper));
        if (this.lo != null) {
            sb.append("\n");
            for (int i = 0; i < this.lo.length; ++i) {
                sb.append(String.format("  [%.4f, %.4f]%n", this.lo[i], this.hi[i]));
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

