/*
 * Decompiled with CFR 0.152.
 */
package smile.association;

import java.util.Arrays;

public class AssociationRule {
    public final int[] antecedent;
    public final int[] consequent;
    public final double support;
    public final double confidence;

    public AssociationRule(int[] antecedent, int[] consequent, double support, double confidence) {
        this.antecedent = antecedent;
        this.consequent = consequent;
        this.support = support;
        this.confidence = confidence;
    }

    public boolean equals(Object o) {
        if (o instanceof AssociationRule) {
            int i;
            AssociationRule a = (AssociationRule)o;
            if (this.support != a.support) {
                return false;
            }
            if (this.confidence != a.confidence) {
                return false;
            }
            if (this.antecedent.length != a.antecedent.length) {
                return false;
            }
            if (this.consequent.length != a.consequent.length) {
                return false;
            }
            for (i = 0; i < this.antecedent.length; ++i) {
                if (this.antecedent[i] == a.antecedent[i]) continue;
                return false;
            }
            for (i = 0; i < this.consequent.length; ++i) {
                if (this.consequent[i] == a.consequent[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + Arrays.hashCode(this.antecedent);
        hash = 13 * hash + Arrays.hashCode(this.consequent);
        hash = 13 * hash + (int)(Double.doubleToLongBits(this.support) ^ Double.doubleToLongBits(this.support) >>> 32);
        hash = 13 * hash + (int)(Double.doubleToLongBits(this.confidence) ^ Double.doubleToLongBits(this.confidence) >>> 32);
        return hash;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(this.antecedent[0]);
        for (i = 1; i < this.antecedent.length; ++i) {
            sb.append(", ");
            sb.append(this.antecedent[i]);
        }
        sb.append(") => (");
        sb.append(this.consequent[0]);
        for (i = 1; i < this.consequent.length; ++i) {
            sb.append(", ");
            sb.append(this.consequent[i]);
        }
        sb.append(String.format(")\tsupport = %.2f%%\tconfidence = %.2f%%", 100.0 * this.support, 100.0 * this.confidence));
        return sb.toString();
    }
}

