/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.impl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.impl.CLTLInfoAccessor;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.llb.CLDeviceBinding;
import com.jogamp.opencl.spi.CLAccessorFactory;
import com.jogamp.opencl.spi.CLInfoAccessor;
import com.jogamp.opencl.spi.CLPlatformInfoAccessor;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class CLTLAccessorFactory
implements CLAccessorFactory {
    @Override
    public CLInfoAccessor createDeviceInfoAccessor(CLDeviceBinding cLDeviceBinding, long l) {
        return new CLDeviceInfoAccessor(cLDeviceBinding, l);
    }

    @Override
    public CLPlatformInfoAccessor createPlatformInfoAccessor(CL cL, long l) {
        return new CLTLPlatformInfoAccessor(cL, l);
    }

    private static final class CLTLPlatformInfoAccessor
    extends CLTLInfoAccessor
    implements CLPlatformInfoAccessor {
        private final long ID;
        private final CL cl;

        private CLTLPlatformInfoAccessor(CL cL, long l) {
            this.ID = l;
            this.cl = cL;
        }

        @Override
        public int getInfo(int n, long l, Buffer buffer, PointerBuffer pointerBuffer) {
            return this.cl.clGetPlatformInfo(this.ID, n, l, buffer, pointerBuffer);
        }

        @Override
        public long[] getDeviceIDs(long l) {
            IntBuffer intBuffer = this.getBB(4).asIntBuffer();
            int n = this.cl.clGetDeviceIDs(this.ID, l, 0, null, intBuffer);
            int n2 = intBuffer.get(0);
            if (n == -1 || n2 == 0) {
                return new long[0];
            }
            CLException.checkForError(n, "error while enumerating devices");
            PointerBuffer pointerBuffer = PointerBuffer.wrap((ByteBuffer)this.getBB(n2 * PointerBuffer.ELEMENT_SIZE));
            n = this.cl.clGetDeviceIDs(this.ID, l, n2, pointerBuffer, null);
            CLException.checkForError(n, "error while enumerating devices");
            long[] lArray = new long[n2];
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = pointerBuffer.get(i);
            }
            return lArray;
        }
    }

    private static final class CLDeviceInfoAccessor
    extends CLTLInfoAccessor {
        private final CLDeviceBinding cl;
        private final long ID;

        private CLDeviceInfoAccessor(CLDeviceBinding cLDeviceBinding, long l) {
            this.cl = cLDeviceBinding;
            this.ID = l;
        }

        @Override
        public int getInfo(int n, long l, Buffer buffer, PointerBuffer pointerBuffer) {
            return this.cl.clGetDeviceInfo(this.ID, n, l, buffer, pointerBuffer);
        }
    }
}

