/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.util;

import cern.colt.function.IntIntDoubleFunction;
import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import edu.emory.mathcs.csparsej.tdouble.Dcs_common;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.RealMatrix;

public class ColtUtils {
    public static Log log = LogFactory.getLog(ColtUtils.class);

    public static final DoubleMatrix1D diagonalMatrixMult(DoubleMatrix1D diagonalM, DoubleMatrix1D vector) {
        int n = diagonalM.size();
        DoubleMatrix1D ret = DoubleFactory1D.dense.make(n);
        for (int i = 0; i < n; ++i) {
            ret.setQuick(i, diagonalM.getQuick(i) * vector.getQuick(i));
        }
        return ret;
    }

    public static final DoubleMatrix2D diagonalMatrixMult(final DoubleMatrix1D diagonalU, DoubleMatrix2D A) {
        DoubleMatrix2D ret;
        int r = diagonalU.size();
        int c = A.columns();
        if (A instanceof SparseDoubleMatrix2D) {
            ret = DoubleFactory2D.sparse.make(r, c);
            A.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int i, int j, double aij) {
                    ret.setQuick(i, j, aij * diagonalU.getQuick(i));
                    return aij;
                }
            });
        } else {
            ret = DoubleFactory2D.dense.make(r, c);
            for (int i = 0; i < r; ++i) {
                for (int j = 0; j < c; ++j) {
                    ret.setQuick(i, j, A.getQuick(i, j) * diagonalU.getQuick(i));
                }
            }
        }
        return ret;
    }

    public static final DoubleMatrix2D diagonalMatrixMult(DoubleMatrix2D A, final DoubleMatrix1D diagonalU) {
        DoubleMatrix2D ret;
        int r = diagonalU.size();
        int c = A.columns();
        if (A instanceof SparseDoubleMatrix2D) {
            ret = DoubleFactory2D.sparse.make(r, c);
            A.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int i, int j, double aij) {
                    ret.setQuick(i, j, aij * diagonalU.getQuick(j));
                    return aij;
                }
            });
        } else {
            ret = DoubleFactory2D.dense.make(r, c);
            for (int i = 0; i < r; ++i) {
                for (int j = 0; j < c; ++j) {
                    ret.setQuick(i, j, A.getQuick(i, j) * diagonalU.getQuick(j));
                }
            }
        }
        return ret;
    }

    public static final DoubleMatrix2D diagonalMatrixMult(final DoubleMatrix1D diagonalU, DoubleMatrix2D A, final DoubleMatrix1D diagonalV) {
        DoubleMatrix2D ret;
        int r = A.rows();
        int c = A.columns();
        if (A instanceof SparseDoubleMatrix2D) {
            ret = DoubleFactory2D.sparse.make(r, c);
            A.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int i, int j, double aij) {
                    ret.setQuick(i, j, aij * diagonalU.getQuick(i) * diagonalV.getQuick(j));
                    return aij;
                }
            });
        } else {
            ret = DoubleFactory2D.dense.make(r, c);
            for (int i = 0; i < r; ++i) {
                for (int j = 0; j < c; ++j) {
                    ret.setQuick(i, j, A.getQuick(i, j) * diagonalU.getQuick(i) * diagonalV.getQuick(j));
                }
            }
        }
        return ret;
    }

    public static DoubleMatrix2D subdiagonalMultiply(DoubleMatrix2D A, final DoubleMatrix2D B) {
        int r = A.rows();
        int rc = A.columns();
        int c = B.columns();
        if (r != c) {
            throw new IllegalArgumentException("The result must be square");
        }
        boolean useSparsity = A instanceof SparseDoubleMatrix2D;
        DoubleFactory2D F2 = useSparsity ? DoubleFactory2D.sparse : DoubleFactory2D.dense;
        final DoubleMatrix2D ret = F2.make(r, c);
        if (useSparsity) {
            IntIntDoubleFunction myFunct = new IntIntDoubleFunction(){

                public double apply(int t, int s, double pts) {
                    int i = t;
                    for (int j = 0; j < i + 1; ++j) {
                        ret.setQuick(i, j, ret.getQuick(i, j) + pts * B.getQuick(s, j));
                    }
                    return pts;
                }
            };
            A.forEachNonZero(myFunct);
        } else {
            for (int i = 0; i < r; ++i) {
                for (int j = 0; j < i + 1; ++j) {
                    double s = 0.0;
                    for (int k = 0; k < rc; ++k) {
                        s += A.getQuick(i, k) * B.getQuick(k, j);
                    }
                    ret.setQuick(i, j, s);
                }
            }
        }
        return ret;
    }

    public static final DoubleMatrix1D zMult(DoubleMatrix2D A, final DoubleMatrix1D b, final double beta) {
        if (A.columns() != b.size()) {
            throw new IllegalArgumentException("wrong matrices dimensions");
        }
        final DoubleMatrix1D ret = DoubleFactory1D.dense.make(A.rows());
        if (A instanceof SparseDoubleMatrix2D) {
            A.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int i, int j, double Aij) {
                    double vi = 0.0;
                    ret.setQuick(i, ret.getQuick(i) + beta * (vi += Aij * b.getQuick(j)));
                    return Aij;
                }
            });
        } else {
            for (int i = 0; i < A.rows(); ++i) {
                double vi = 0.0;
                for (int j = 0; j < A.columns(); ++j) {
                    vi += A.getQuick(i, j) * b.getQuick(j);
                }
                ret.setQuick(i, beta * vi);
            }
        }
        return ret;
    }

    public static final DoubleMatrix1D zMult(DoubleMatrix2D A, final DoubleMatrix1D a, DoubleMatrix1D b, double beta) {
        if (A.columns() != a.size() || A.rows() != b.size()) {
            throw new IllegalArgumentException("wrong matrices dimensions");
        }
        final DoubleMatrix1D ret = DoubleFactory1D.dense.make(A.rows());
        if (A instanceof SparseDoubleMatrix2D) {
            A.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int i, int j, double Aij) {
                    ret.setQuick(i, ret.getQuick(i) + Aij * a.getQuick(j));
                    return Aij;
                }
            });
            for (int i = 0; i < ret.size(); ++i) {
                ret.setQuick(i, ret.getQuick(i) + beta * b.getQuick(i));
            }
        } else {
            for (int i = 0; i < A.rows(); ++i) {
                double vi = beta * b.getQuick(i);
                for (int j = 0; j < A.columns(); ++j) {
                    vi += A.getQuick(i, j) * a.getQuick(j);
                }
                ret.setQuick(i, vi);
            }
        }
        return ret;
    }

    public static final DoubleMatrix1D zMultTranspose(DoubleMatrix2D A, final DoubleMatrix1D a, DoubleMatrix1D b, double beta) {
        DoubleMatrix1D ret;
        block5: {
            block4: {
                if (A.rows() != a.size() || A.columns() != b.size()) {
                    throw new IllegalArgumentException("wrong matrices dimensions");
                }
                ret = DoubleFactory1D.dense.make(A.columns());
                if (!(A instanceof SparseDoubleMatrix2D)) break block4;
                A.forEachNonZero(new IntIntDoubleFunction(){

                    public double apply(int i, int j, double Aij) {
                        ret.setQuick(j, ret.getQuick(j) + Aij * a.getQuick(i));
                        return Aij;
                    }
                });
                if (Double.compare(0.0, beta) == 0) break block5;
                for (int i = 0; i < ret.size(); ++i) {
                    ret.setQuick(i, ret.getQuick(i) + beta * b.getQuick(i));
                }
                break block5;
            }
            for (int i = 0; i < A.columns(); ++i) {
                double vi = beta * b.getQuick(i);
                for (int j = 0; j < A.rows(); ++j) {
                    vi += A.getQuick(j, i) * a.getQuick(j);
                }
                ret.setQuick(i, vi);
            }
        }
        return ret;
    }

    public static final DoubleMatrix2D add(DoubleMatrix2D A, DoubleMatrix2D B) {
        if (A.rows() != B.rows() || A.columns() != B.columns()) {
            throw new IllegalArgumentException("wrong matrices dimensions");
        }
        DoubleMatrix2D ret = DoubleFactory2D.dense.make(A.rows(), A.columns());
        for (int i = 0; i < ret.rows(); ++i) {
            for (int j = 0; j < ret.columns(); ++j) {
                ret.setQuick(i, j, A.getQuick(i, j) + B.getQuick(i, j));
            }
        }
        return ret;
    }

    public static final DoubleMatrix2D add(DoubleMatrix2D A, DoubleMatrix2D B, double beta) {
        if (A.rows() != B.rows() || A.columns() != B.columns()) {
            throw new IllegalArgumentException("wrong matrices dimensions");
        }
        DoubleMatrix2D ret = DoubleFactory2D.dense.make(A.rows(), A.columns());
        for (int i = 0; i < ret.rows(); ++i) {
            for (int j = 0; j < ret.columns(); ++j) {
                ret.setQuick(i, j, A.getQuick(i, j) + beta * B.getQuick(i, j));
            }
        }
        return ret;
    }

    public static final DoubleMatrix1D add(DoubleMatrix1D v1, DoubleMatrix1D v2) {
        if (v1.size() != v2.size()) {
            throw new IllegalArgumentException("wrong vectors dimensions");
        }
        DoubleMatrix1D ret = DoubleFactory1D.dense.make(v1.size());
        for (int i = 0; i < ret.size(); ++i) {
            ret.setQuick(i, v1.getQuick(i) + v2.getQuick(i));
        }
        return ret;
    }

    public static final DoubleMatrix1D add(DoubleMatrix1D v1, DoubleMatrix1D v2, double c) {
        if (v1.size() != v2.size()) {
            throw new IllegalArgumentException("wrong vectors dimensions");
        }
        DoubleMatrix1D ret = DoubleFactory1D.dense.make(v1.size());
        for (int i = 0; i < ret.size(); ++i) {
            ret.setQuick(i, v1.getQuick(i) + c * v2.getQuick(i));
        }
        return ret;
    }

    public static final DoubleMatrix1D scalarMult(DoubleMatrix1D v1, double c) {
        DoubleMatrix1D ret = DoubleFactory1D.dense.make(v1.size());
        for (int i = 0; i < ret.size(); ++i) {
            ret.setQuick(i, c * v1.getQuick(i));
        }
        return ret;
    }

    public static final Dcs_common.Dcs matrixToDcs(SparseDoubleMatrix2D A) {
        int m = A.rows();
        int n = A.columns();
        int nz = -1;
        int nzmax = m * n;
        final int[] p = new int[n + 1];
        final int[] i = new int[nzmax];
        final double[] x = new double[nzmax];
        final int[] currentColumnIndexHolder = new int[]{-1};
        IntIntDoubleFunction myFunct = new IntIntDoubleFunction(){
            int nzCounter = 0;

            public double apply(int r, int c, double prc) {
                i[this.nzCounter] = r;
                x[this.nzCounter] = prc;
                ++this.nzCounter;
                p[currentColumnIndexHolder[0] + 1] = p[currentColumnIndexHolder[0] + 1] + 1;
                return prc;
            }
        };
        int c = 0;
        while (c < n) {
            DoubleMatrix2D P = A.viewPart(0, c, m, 1);
            currentColumnIndexHolder[0] = c++;
            p[currentColumnIndexHolder[0] + 1] = p[currentColumnIndexHolder[0]];
            P.forEachNonZero(myFunct);
        }
        Dcs_common.Dcs dcs = new Dcs_common.Dcs();
        dcs.m = m;
        dcs.n = n;
        dcs.nz = nz;
        dcs.nzmax = nzmax;
        dcs.p = p;
        dcs.i = i;
        dcs.x = x;
        return dcs;
    }

    public static final SparseDoubleMatrix2D dcsToMatrix(Dcs_common.Dcs dcs) {
        SparseDoubleMatrix2D A = new SparseDoubleMatrix2D(dcs.m, dcs.n);
        int[] rowIndexes = dcs.i;
        int[] columnPointers = dcs.p;
        double[] values = dcs.x;
        int cnt = 0;
        for (int j = 0; j < dcs.n; ++j) {
            int colStartIndex = columnPointers[j];
            int colEndIndex = columnPointers[j + 1];
            for (int pointer = colStartIndex; pointer < colEndIndex; ++pointer) {
                int i = rowIndexes[pointer];
                A.setQuick(i, j, values[cnt]);
                ++cnt;
            }
        }
        return A;
    }

    public static final DoubleMatrix1D replaceValues(DoubleMatrix1D v, double oldValue, double newValue) {
        if (v == null) {
            return null;
        }
        DoubleFactory1D F1 = v instanceof SparseDoubleMatrix1D ? DoubleFactory1D.sparse : DoubleFactory1D.dense;
        DoubleMatrix1D ret = F1.make(v.size());
        for (int i = 0; i < v.size(); ++i) {
            double vi = v.getQuick(i);
            if (Double.compare(oldValue, vi) != 0) {
                ret.setQuick(i, vi);
                continue;
            }
            ret.setQuick(i, newValue);
        }
        return ret;
    }

    public static final DoubleMatrix2D invert2x2Matrix(DoubleMatrix2D A) throws Exception {
        if (2 != A.rows() || A.rows() != A.columns()) {
            throw new IllegalArgumentException("matrix is not 2x2");
        }
        double s = A.getQuick(0, 0) * A.getQuick(1, 1) - A.getQuick(0, 1) * A.getQuick(1, 0);
        if (Math.abs(s) < 1.0E-16) {
            throw new Exception("Matrix is singular");
        }
        DenseDoubleMatrix2D ret = new DenseDoubleMatrix2D(2, 2);
        ((DoubleMatrix2D)ret).setQuick(0, 0, A.getQuick(1, 1) / s);
        ((DoubleMatrix2D)ret).setQuick(1, 1, A.getQuick(0, 0) / s);
        ((DoubleMatrix2D)ret).setQuick(0, 1, -A.getQuick(1, 0) / s);
        ((DoubleMatrix2D)ret).setQuick(1, 0, A.getQuick(0, 1) / s);
        return ret;
    }

    public static final DoubleMatrix2D symmPermutation(DoubleMatrix2D A, int from, int to) {
        int n = A.rows();
        int[] rowIndexes = new int[n];
        int[] columnIndexes = new int[n];
        for (int i = 0; i < n; ++i) {
            rowIndexes[i] = i;
            columnIndexes[i] = i;
        }
        rowIndexes[from] = to;
        rowIndexes[to] = from;
        columnIndexes[from] = to;
        columnIndexes[to] = from;
        return Algebra.DEFAULT.permute(A, rowIndexes, columnIndexes);
    }

    public static double[] getConditionNumberRange(RealMatrix A, int p) {
        double infLimit = Double.NEGATIVE_INFINITY;
        double supLimit = Double.POSITIVE_INFINITY;
        ArrayList<Double> columnNormsList = new ArrayList<Double>();
        switch (p) {
            case 2: {
                for (int j = 0; j < A.getColumnDimension(); ++j) {
                    columnNormsList.add(A.getColumnVector(j).getL1Norm());
                }
                Collections.sort(columnNormsList);
                infLimit = (Double)columnNormsList.get(columnNormsList.size() - 1) / (Double)columnNormsList.get(0);
                break;
            }
            case 0x7FFFFFFF: {
                double normAInf = A.getNorm();
                for (int j = 0; j < A.getColumnDimension(); ++j) {
                    columnNormsList.add(A.getColumnVector(j).getLInfNorm());
                }
                Collections.sort(columnNormsList);
                infLimit = normAInf / (Double)columnNormsList.get(0);
                break;
            }
            default: {
                throw new IllegalArgumentException("p must be 2 or Integer.MAX_VALUE");
            }
        }
        return new double[]{infLimit, supLimit};
    }

    public static final DoubleMatrix2D fillSubdiagonalSymmetricMatrix(DoubleMatrix2D S) {
        if (S.rows() != S.columns()) {
            throw new IllegalArgumentException("Not square matrix");
        }
        boolean isSparse = S instanceof SparseDoubleMatrix2D;
        DoubleFactory2D F2D = isSparse ? DoubleFactory2D.sparse : DoubleFactory2D.dense;
        final DoubleMatrix2D SFull = F2D.make(S.rows(), S.rows());
        if (isSparse) {
            S.forEachNonZero(new IntIntDoubleFunction(){

                public double apply(int i, int j, double hij) {
                    SFull.setQuick(i, j, hij);
                    SFull.setQuick(j, i, hij);
                    return hij;
                }
            });
        } else {
            for (int i = 0; i < S.rows(); ++i) {
                for (int j = 0; j < i + 1; ++j) {
                    double sij = S.getQuick(i, j);
                    SFull.setQuick(i, j, sij);
                    SFull.setQuick(j, i, sij);
                }
            }
        }
        return SFull;
    }

    public static final double calculateDeterminant(DoubleMatrix2D A) {
        double det = 0.0;
        int dim = A.rows();
        if (dim == 1) {
            det = A.getQuick(0, 0);
        } else if (dim == 2) {
            det = A.getQuick(0, 0) * A.getQuick(1, 1) - A.getQuick(0, 1) * A.getQuick(1, 0);
        } else {
            DoubleMatrix1D A0 = A.viewRow(0);
            for (int k = 0; k < dim; ++k) {
                double A0k = A0.getQuick(k);
                if (!(A0k < 0.0) && !(A0k > 0.0)) continue;
                int[] rowIndexes = new int[A.rows() - 1];
                for (int i = 1; i < A.rows(); ++i) {
                    rowIndexes[i - 1] = i;
                }
                int[] columnIndexes = new int[A.columns() - 1];
                int cnt = 0;
                for (int j = 0; j < A.columns(); ++j) {
                    if (j == k) continue;
                    columnIndexes[cnt] = j;
                    ++cnt;
                }
                DoubleMatrix2D Aminor = A.viewSelection(rowIndexes, columnIndexes);
                if (k % 2 == 0) {
                    det += A0k * ColtUtils.calculateDeterminant(Aminor);
                    continue;
                }
                det -= A0k * ColtUtils.calculateDeterminant(Aminor);
            }
        }
        return det;
    }
}

