/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.solvers;

import cern.colt.function.IntIntDoubleFunction;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.jet.math.Functions;
import cern.jet.math.Mult;
import com.joptimizer.algebra.CholeskyFactorization;
import com.joptimizer.algebra.Matrix1NormRescaler;
import com.joptimizer.solvers.KKTSolver;
import com.joptimizer.util.ColtUtils;
import com.joptimizer.util.Utils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiagonalHKKTSolver
extends KKTSolver {
    private boolean avoidScaling = false;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public DiagonalHKKTSolver() {
        this(false);
    }

    public DiagonalHKKTSolver(boolean avoidScaling) {
        this.avoidScaling = avoidScaling;
    }

    public DoubleMatrix1D[] solve() throws Exception {
        DoubleMatrix1D v = null;
        DoubleMatrix1D w = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("H: " + ArrayUtils.toString((Object)ColtUtils.fillSubdiagonalSymmetricMatrix(this.H).toArray())));
            this.log.debug((Object)("g: " + ArrayUtils.toString((Object)this.g.toArray())));
            if (this.A != null) {
                this.log.debug((Object)("A: " + ArrayUtils.toString((Object)this.A.toArray())));
                this.log.debug((Object)("h: " + ArrayUtils.toString((Object)this.h.toArray())));
            }
        }
        DoubleMatrix1D HInvg = this.F1.make(this.H.rows());
        for (int i = 0; i < this.H.rows(); ++i) {
            double d = this.H.getQuick(i, i);
            if (d < Utils.getDoubleMachineEpsilon()) {
                throw new Exception("not positive definite matrix");
            }
            HInvg.setQuick(i, this.g.getQuick(i) / d);
        }
        if (this.A != null) {
            DoubleMatrix2D HInvAT = this.calculateHAT(this.H, this.A);
            DoubleMatrix2D MenoSLower = this.calculateSubdiagonalAHAT(this.A, this.H);
            this.log.debug((Object)("MenoS: " + ArrayUtils.toString((Object)ColtUtils.fillSubdiagonalSymmetricMatrix(MenoSLower).toArray())));
            DoubleMatrix1D AHInvg = this.ALG.mult(this.A, HInvg);
            Matrix1NormRescaler rescaler = this.avoidScaling ? null : new Matrix1NormRescaler();
            CholeskyFactorization MSFact = new CholeskyFactorization(MenoSLower, rescaler);
            try {
                MSFact.factorize();
                if (this.h == null) {
                    w = MSFact.solve(ColtUtils.scalarMult(AHInvg, -1.0));
                } else {
                    DoubleMatrix1D hmAHInvg = ColtUtils.add(this.h, AHInvg, -1.0);
                    w = MSFact.solve(hmAHInvg);
                }
                v = HInvg.assign(this.ALG.mult(HInvAT, w), Functions.plus).assign(Mult.mult(-1.0));
            }
            catch (Exception e) {
                this.log.warn((Object)("warn: " + e.getMessage()));
                this.log.debug((Object)("MenoS: " + ArrayUtils.toString((Object)ColtUtils.fillSubdiagonalSymmetricMatrix(MenoSLower).toArray())));
                try {
                    DoubleMatrix1D[] fullSol = this.solveAugmentedKKT();
                    v = fullSol[0];
                    w = fullSol[1];
                }
                catch (Exception ex) {
                    this.log.error((Object)ex.getMessage());
                    throw new Exception("KKT solution failed");
                }
            }
        } else {
            w = null;
            v = HInvg.assign(Mult.mult(-1.0));
        }
        if (this.checkKKTSolutionAccuracy && !this.checkKKTSolutionAccuracy(v, w)) {
            this.log.error((Object)"KKT solution failed");
            throw new Exception("KKT solution failed");
        }
        DoubleMatrix1D[] ret = new DoubleMatrix1D[]{v, w};
        return ret;
    }

    private DoubleMatrix2D calculateHAT(final DoubleMatrix2D HH, DoubleMatrix2D AA) {
        final DoubleMatrix2D ret = DoubleFactory2D.sparse.make(AA.columns(), AA.rows());
        AA.forEachNonZero(new IntIntDoubleFunction(){

            public double apply(int i, int j, double aij) {
                ret.setQuick(j, i, aij * HH.getQuick(j, j));
                return aij;
            }
        });
        return ret;
    }

    private DoubleMatrix2D calculateSubdiagonalAHAT(final DoubleMatrix2D AA, final DoubleMatrix2D HH) {
        final DoubleMatrix2D ret = DoubleFactory2D.sparse.make(AA.rows(), AA.rows());
        final int[] rowHolder = new int[]{-1};
        final int[] colHolder = new int[]{-1};
        final double[] valueHolder = new double[]{Double.NaN};
        final IntIntDoubleFunction myFunc = new IntIntDoubleFunction(){

            public double apply(int r, int c, double AAColrc) {
                if (c < rowHolder[0] + 1) {
                    ret.setQuick(r, rowHolder[0], ret.getQuick(r, rowHolder[0]) + valueHolder[0] * AAColrc * HH.getQuick(colHolder[0], colHolder[0]));
                }
                return AAColrc;
            }
        };
        AA.forEachNonZero(new IntIntDoubleFunction(){

            public double apply(int i, int j, double aij) {
                rowHolder[0] = i;
                colHolder[0] = j;
                valueHolder[0] = aij;
                DoubleMatrix2D AACol = AA.viewPart(0, j, AA.rows(), 1);
                AACol.forEachNonZero(myFunc);
                return aij;
            }
        });
        return ret;
    }

    protected boolean checkKKTSolutionAccuracy(DoubleMatrix1D v, DoubleMatrix1D w) {
        this.log.debug((Object)"checkKKTSolutionAccuracy");
        DoubleMatrix2D KKT = null;
        DoubleMatrix1D x = null;
        DoubleMatrix1D b = null;
        if (this.A != null) {
            DoubleMatrix2D[][] parts;
            if (this.h != null) {
                parts = new DoubleMatrix2D[][]{{this.H, this.AT}, {this.A, null}};
                KKT = this.A instanceof SparseDoubleMatrix2D ? DoubleFactory2D.sparse.compose(parts) : DoubleFactory2D.dense.compose(parts);
                x = this.F1.append(v, w);
                b = this.F1.append(this.g, this.h).assign(Mult.mult(-1.0));
            } else {
                parts = new DoubleMatrix2D[][]{{this.H, this.AT}};
                KKT = this.A instanceof SparseDoubleMatrix2D ? DoubleFactory2D.sparse.compose(parts) : DoubleFactory2D.dense.compose(parts);
                x = this.F1.append(v, w);
                b = ColtUtils.scalarMult(this.g, -1.0);
            }
        } else {
            KKT = this.H;
            x = v;
            b = ColtUtils.scalarMult(this.g, -1.0);
        }
        double scaledResidual = Utils.calculateScaledResidual(KKT, x, b);
        this.log.info((Object)("KKT inversion scaled residual: " + scaledResidual));
        return scaledResidual < this.toleranceKKT;
    }
}

