/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.solvers;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.jet.math.Functions;
import cern.jet.math.Mult;
import com.joptimizer.algebra.CholeskyFactorization;
import com.joptimizer.algebra.Matrix1NormRescaler;
import com.joptimizer.solvers.KKTSolver;
import com.joptimizer.util.ColtUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicKKTSolver
extends KKTSolver {
    private boolean avoidScaling = false;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public BasicKKTSolver() {
        this(false);
    }

    public BasicKKTSolver(boolean avoidScaling) {
        this.avoidScaling = avoidScaling;
    }

    public DoubleMatrix1D[] solve() throws Exception {
        DoubleMatrix1D v = null;
        DoubleMatrix1D w = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("H: " + ArrayUtils.toString((Object)this.H.toArray())));
            this.log.debug((Object)("g: " + ArrayUtils.toString((Object)this.g.toArray())));
            if (this.A != null) {
                this.log.debug((Object)("A: " + ArrayUtils.toString((Object)this.A.toArray())));
            }
            if (this.h != null) {
                this.log.debug((Object)("h: " + ArrayUtils.toString((Object)this.h.toArray())));
            }
        }
        CholeskyFactorization HFact = new CholeskyFactorization(this.H, new Matrix1NormRescaler());
        boolean isHReducible = true;
        try {
            HFact.factorize();
        }
        catch (Exception e) {
            isHReducible = false;
        }
        if (isHReducible) {
            DoubleMatrix1D HInvg = HFact.solve(this.g);
            if (this.A != null) {
                DoubleMatrix2D HInvAT = HFact.solve(this.AT);
                DoubleMatrix2D MenoSLower = ColtUtils.subdiagonalMultiply(this.A, HInvAT);
                DoubleMatrix1D AHInvg = this.ALG.mult(this.A, HInvg);
                CholeskyFactorization MSFact = new CholeskyFactorization(MenoSLower, new Matrix1NormRescaler());
                MSFact.factorize();
                w = this.h == null ? MSFact.solve(ColtUtils.scalarMult(AHInvg, -1.0)) : MSFact.solve(ColtUtils.add(this.h, AHInvg, -1.0));
                v = HInvg.assign(this.ALG.mult(HInvAT, w), Functions.plus).assign(Mult.mult(-1.0));
            } else {
                w = null;
                v = HInvg.assign(Mult.mult(-1.0));
            }
        } else if (this.A != null) {
            DoubleMatrix1D[] fullSol = this.solveAugmentedKKT();
            v = fullSol[0];
            w = fullSol[1];
        } else {
            throw new Exception("KKT solution failed");
        }
        if (this.checkKKTSolutionAccuracy && !this.checkKKTSolutionAccuracy(v, w)) {
            this.log.error((Object)"KKT solution failed");
            throw new Exception("KKT solution failed");
        }
        DoubleMatrix1D[] ret = new DoubleMatrix1D[]{v, w};
        return ret;
    }
}

