/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.optimizers;

import cern.colt.function.IntIntDoubleFunction;
import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import com.joptimizer.algebra.QRSparseFactorization;
import com.joptimizer.functions.ConvexMultivariateRealFunction;
import com.joptimizer.functions.FunctionsUtils;
import com.joptimizer.optimizers.OptimizationRequest;
import com.joptimizer.optimizers.OptimizationResponse;
import com.joptimizer.util.ColtUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;

public abstract class OptimizationRequestHandler {
    protected OptimizationRequestHandler successor = null;
    protected OptimizationRequest request;
    protected OptimizationResponse response;
    protected int dim = -1;
    protected int meq = -1;
    protected int mieq = -1;
    protected Algebra ALG = Algebra.DEFAULT;
    protected DoubleFactory1D F1 = DoubleFactory1D.dense;
    protected DoubleFactory2D F2 = DoubleFactory2D.dense;
    private DoubleMatrix2D AT = null;

    public void setOptimizationRequest(OptimizationRequest request) {
        this.request = request;
    }

    protected OptimizationRequest getOptimizationRequest() {
        return this.request;
    }

    protected void setOptimizationResponse(OptimizationResponse response) {
        this.response = response;
    }

    public OptimizationResponse getOptimizationResponse() {
        return this.response;
    }

    public int optimize() throws Exception {
        return this.forwardOptimizationRequest();
    }

    protected int forwardOptimizationRequest() throws Exception {
        if (this.successor != null) {
            this.successor.setOptimizationRequest(this.request);
            int retCode = this.successor.optimize();
            this.response = this.successor.getOptimizationResponse();
            return retCode;
        }
        throw new Exception("Failed to solve the problem");
    }

    protected final int getDim() {
        if (this.dim < 0) {
            this.dim = this.request.getF0().getDim();
        }
        return this.dim;
    }

    protected final int getMeq() {
        if (this.meq < 0) {
            this.meq = this.request.getA() == null ? 0 : this.request.getA().rows();
        }
        return this.meq;
    }

    protected final int getMieq() {
        if (this.mieq < 0) {
            this.mieq = this.getFi().length;
        }
        return this.mieq;
    }

    protected DoubleMatrix1D getInitialPoint() {
        return this.request.getInitialPoint();
    }

    protected DoubleMatrix1D getNotFeasibleInitialPoint() {
        return this.request.getNotFeasibleInitialPoint();
    }

    protected DoubleMatrix1D getInitialLagrangian() {
        return this.request.getInitialLagrangian();
    }

    protected final DoubleMatrix2D getA() {
        return this.request.getA();
    }

    protected final DoubleMatrix2D getAT() {
        if (this.AT == null && this.getA() != null) {
            this.AT = this.ALG.transpose(this.getA());
        }
        return this.AT;
    }

    protected final DoubleMatrix1D getB() {
        return this.request.getB();
    }

    protected final int getMaxIteration() {
        return this.request.getMaxIteration();
    }

    protected final double getTolerance() {
        return this.request.getTolerance();
    }

    protected final double getToleranceFeas() {
        return this.request.getToleranceFeas();
    }

    protected final double getToleranceInnerStep() {
        return this.request.getToleranceInnerStep();
    }

    protected final double getAlpha() {
        return this.request.getAlpha();
    }

    protected final double getBeta() {
        return this.request.getBeta();
    }

    protected final double getMu() {
        return this.request.getMu();
    }

    protected final boolean isCheckProgressConditions() {
        return this.request.isCheckProgressConditions();
    }

    protected final boolean isCheckKKTSolutionAccuracy() {
        return this.request.isCheckKKTSolutionAccuracy();
    }

    protected final double getToleranceKKT() {
        return this.request.getToleranceKKT();
    }

    protected final String getInteriorPointMethod() {
        return this.request.getInteriorPointMethod();
    }

    protected final ConvexMultivariateRealFunction getF0() {
        return this.request.getF0();
    }

    protected boolean isInDomainF0(DoubleMatrix1D X) {
        double F0X = this.request.getF0().value(X.toArray());
        return !Double.isInfinite(F0X) && !Double.isNaN(F0X);
    }

    protected double getF0(DoubleMatrix1D X) {
        return this.request.getF0().value(X.toArray());
    }

    protected DoubleMatrix1D getGradF0(DoubleMatrix1D X) {
        return this.F1.make(this.request.getF0().gradient(X.toArray()));
    }

    protected DoubleMatrix2D getHessF0(DoubleMatrix1D X) {
        double[][] hess = this.request.getF0().hessian(X.toArray());
        if (hess == FunctionsUtils.ZEROES_2D_ARRAY_PLACEHOLDER) {
            return this.F2.make(X.size(), X.size());
        }
        return this.F2.make(hess);
    }

    protected ConvexMultivariateRealFunction[] getFi() {
        return this.request.getFi();
    }

    protected DoubleMatrix1D getFi(DoubleMatrix1D X) {
        if (this.request.getFi() == null) {
            return null;
        }
        double[] ret = new double[this.request.getFi().length];
        double[] x = X.toArray();
        for (int i = 0; i < this.request.getFi().length; ++i) {
            ret[i] = this.request.getFi()[i].value(x);
        }
        return this.F1.make(ret);
    }

    protected DoubleMatrix2D getGradFi(DoubleMatrix1D X) {
        DoubleMatrix2D ret = this.F2.make(this.request.getFi().length, X.size());
        double[] x = X.toArray();
        for (int i = 0; i < this.request.getFi().length; ++i) {
            ret.viewRow(i).assign(this.request.getFi()[i].gradient(x));
        }
        return ret;
    }

    protected DoubleMatrix2D[] getHessFi(DoubleMatrix1D X) {
        DoubleMatrix2D[] ret = new DoubleMatrix2D[this.request.getFi().length];
        double[] x = X.toArray();
        for (int i = 0; i < this.request.getFi().length; ++i) {
            double[][] hess = this.request.getFi()[i].hessian(x);
            ret[i] = hess == FunctionsUtils.ZEROES_2D_ARRAY_PLACEHOLDER ? FunctionsUtils.ZEROES_MATRIX_PLACEHOLDER : this.F2.make(hess);
        }
        return ret;
    }

    protected boolean checkCustomExitConditions(DoubleMatrix1D Y) {
        return false;
    }

    protected DoubleMatrix1D findEqFeasiblePoint(DoubleMatrix2D AMatrix, DoubleMatrix1D bVector) throws Exception {
        int p = AMatrix.rows();
        int m = AMatrix.columns();
        if (m <= p) {
            LogFactory.getLog((String)this.getClass().getName()).error((Object)"Equalities matrix A must be pxn with rank(A) = p < n");
            throw new RuntimeException("Equalities matrix A must be pxn with rank(A) = p < n");
        }
        if (AMatrix instanceof SparseDoubleMatrix2D) {
            QRSparseFactorization qr = new QRSparseFactorization((SparseDoubleMatrix2D)AMatrix);
            qr.factorize();
            DoubleMatrix1D x = qr.solve(bVector);
            return x;
        }
        return this.findEqFeasiblePoint2(AMatrix, bVector);
    }

    protected DoubleMatrix1D findEqFeasiblePoint2(DoubleMatrix2D AMatrix, DoubleMatrix1D bVector) throws Exception {
        int p = AMatrix.rows();
        int m = AMatrix.columns();
        if (m <= p) {
            LogFactory.getLog((String)this.getClass().getName()).error((Object)"Equalities matrix A must be pxn with rank(A) = p < n");
            throw new RuntimeException("Equalities matrix A must be pxn with rank(A) = p < n");
        }
        Array2DRowRealMatrix AT = new Array2DRowRealMatrix(AMatrix.columns(), AMatrix.rows());
        if (AMatrix instanceof SparseDoubleMatrix2D) {
            ((SparseDoubleMatrix2D)AMatrix).forEachNonZero(new IntIntDoubleFunction((RealMatrix)AT){
                final /* synthetic */ RealMatrix val$AT;
                {
                    this.val$AT = realMatrix;
                }

                public double apply(int i, int j, double aij) {
                    this.val$AT.setEntry(j, i, aij);
                    return aij;
                }
            });
        } else {
            for (int i = 0; i < AMatrix.rows(); ++i) {
                for (int j = 0; j < AMatrix.columns(); ++j) {
                    AT.setEntry(j, i, AMatrix.getQuick(i, j));
                }
            }
        }
        SingularValueDecomposition dFact1 = new SingularValueDecomposition((RealMatrix)AT);
        int rankAT = dFact1.getRank();
        if (rankAT != p) {
            LogFactory.getLog((String)this.getClass().getName()).error((Object)("Equalities matrix A must have full rank: " + rankAT + " < " + p));
            throw new RuntimeException("Equalities matrix A must have full rank: " + rankAT + " < " + p);
        }
        QRDecomposition dFact = new QRDecomposition((RealMatrix)AT);
        RealMatrix Q1Q2 = dFact.getQ();
        RealMatrix R0 = dFact.getR();
        RealMatrix Q1 = Q1Q2.getSubMatrix(0, AT.getRowDimension() - 1, 0, p - 1);
        RealMatrix R = R0.getSubMatrix(0, p - 1, 0, p - 1);
        double[] w = null;
        double[] x = new double[p];
        for (int i = 0; i < p; ++i) {
            double sum = 0.0;
            for (int j = 0; j < i; ++j) {
                sum += R.getEntry(j, i) * x[j];
            }
            x[i] = (bVector.getQuick(i) - sum) / R.getEntry(i, i);
        }
        w = Q1.operate(x);
        return this.F1.make(w);
    }

    protected DoubleMatrix1D rPri(DoubleMatrix1D X) {
        if (this.getA() == null) {
            return this.F1.make(0);
        }
        return ColtUtils.zMult(this.getA(), X, this.getB(), -1.0);
    }
}

