/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.optimizers;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import com.joptimizer.functions.StrictlyConvexMultivariateRealFunction;
import com.joptimizer.optimizers.NewtonLEConstrainedFSP;
import com.joptimizer.optimizers.OptimizationRequestHandler;
import com.joptimizer.optimizers.OptimizationResponse;
import com.joptimizer.solvers.BasicKKTSolver;
import com.joptimizer.solvers.KKTSolver;
import com.joptimizer.util.ColtUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NewtonUnconstrained
extends OptimizationRequestHandler {
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public NewtonUnconstrained(boolean activateChain) {
        if (activateChain) {
            this.successor = new NewtonLEConstrainedFSP(true);
        }
    }

    public NewtonUnconstrained() {
        this(false);
    }

    public int optimize() throws Exception {
        this.log.debug((Object)"optimize");
        OptimizationResponse response = new OptimizationResponse();
        if (this.getA() != null || this.getFi() != null) {
            return this.forwardOptimizationRequest();
        }
        if (!(this.getF0() instanceof StrictlyConvexMultivariateRealFunction)) {
            throw new Exception("Unsolvable problem");
        }
        long tStart = System.currentTimeMillis();
        DoubleMatrix1D X0 = this.getInitialPoint();
        if (X0 == null) {
            X0 = this.F1.make(this.getDim());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("X0:  " + ArrayUtils.toString((Object)X0.toArray())));
        }
        DoubleMatrix1D X = X0;
        double previousLambda = Double.NaN;
        int iteration = 0;
        while (true) {
            ++iteration;
            double F0X = this.getF0(X);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("iteration " + iteration));
                this.log.debug((Object)("X=" + ArrayUtils.toString((Object)X.toArray())));
                this.log.debug((Object)("f(X)=" + F0X));
            }
            if (this.checkCustomExitConditions(X)) {
                response.setReturnCode(0);
                break;
            }
            DoubleMatrix1D gradX = this.getGradF0(X);
            DoubleMatrix2D hessX = this.getHessF0(X);
            DoubleMatrix1D step = this.calculateNewtonStep(hessX, gradX);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("step: " + ArrayUtils.toString((Object)step.toArray())));
            }
            double lambda = Math.sqrt(-this.ALG.mult(gradX, step));
            this.log.debug((Object)("lambda: " + lambda));
            if (lambda / 2.0 <= this.getTolerance()) {
                response.setReturnCode(0);
                break;
            }
            if (iteration == this.getMaxIteration()) {
                response.setReturnCode(2);
                this.log.error((Object)"Max iterations limit reached");
                throw new Exception("Max iterations limit reached");
            }
            if (this.isCheckProgressConditions()) {
                this.log.debug((Object)("previous: " + previousLambda));
                if (!Double.isNaN(previousLambda) && previousLambda <= lambda) {
                    this.log.error((Object)"No progress achieved, exit iterations loop without desired accuracy");
                    response.setReturnCode(2);
                    throw new Exception("No progress achieved, exit iterations loop without desired accuracy");
                }
            }
            previousLambda = lambda;
            double s = 1.0;
            DoubleMatrix1D X1 = null;
            for (int cnt = 0; cnt < 25; ++cnt) {
                double condDX;
                X1 = ColtUtils.add(X, step, s);
                double condSX = this.getF0(X1);
                if (condSX <= (condDX = F0X + this.getAlpha() * s * this.ALG.mult(gradX, step))) break;
                s = this.getBeta() * s;
            }
            this.log.debug((Object)("s: " + s));
            X = X1;
        }
        long tStop = System.currentTimeMillis();
        this.log.debug((Object)("time: " + (tStop - tStart)));
        response.setSolution(X.toArray());
        this.setOptimizationResponse(response);
        return response.getReturnCode();
    }

    private DoubleMatrix1D calculateNewtonStep(DoubleMatrix2D hessX, DoubleMatrix1D gradX) throws Exception {
        BasicKKTSolver kktSolver = new BasicKKTSolver();
        if (this.isCheckKKTSolutionAccuracy()) {
            kktSolver.setCheckKKTSolutionAccuracy(this.isCheckKKTSolutionAccuracy());
            kktSolver.setToleranceKKT(this.getToleranceKKT());
        }
        kktSolver.setHMatrix(hessX);
        kktSolver.setGVector(gradX);
        DoubleMatrix1D[] sol = ((KKTSolver)kktSolver).solve();
        DoubleMatrix1D step = sol[0];
        return step;
    }
}

