/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.optimizers;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import com.joptimizer.functions.LogarithmicBarrier;
import com.joptimizer.optimizers.BarrierMethod;
import com.joptimizer.optimizers.NewtonLEConstrainedFSP;
import com.joptimizer.optimizers.OptimizationRequest;
import com.joptimizer.optimizers.OptimizationRequestHandler;
import com.joptimizer.optimizers.OptimizationResponse;
import com.joptimizer.optimizers.PrimalDualMethod;
import com.joptimizer.solvers.BasicKKTSolver;
import com.joptimizer.solvers.KKTSolver;
import com.joptimizer.util.ColtUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NewtonLEConstrainedISP
extends OptimizationRequestHandler {
    private KKTSolver kktSolver;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public NewtonLEConstrainedISP(boolean activateChain) {
        if (activateChain) {
            this.successor = new PrimalDualMethod();
        }
    }

    public NewtonLEConstrainedISP() {
        this(false);
    }

    public int optimize() throws Exception {
        DoubleMatrix1D V0;
        this.log.debug((Object)"optimize");
        OptimizationResponse response = new OptimizationResponse();
        if (this.getFi() != null) {
            return this.forwardOptimizationRequest();
        }
        long tStart = System.currentTimeMillis();
        DoubleMatrix1D X0 = this.getInitialPoint();
        if (X0 == null) {
            if (this.getA() != null) {
                X0 = this.findEqFeasiblePoint(this.getA(), this.getB());
                this.log.debug((Object)"Switch to the linear equality feasible starting point Newton algorithm ");
                NewtonLEConstrainedFSP opt = new NewtonLEConstrainedFSP();
                OptimizationRequest req = this.getOptimizationRequest();
                req.setInitialPoint(X0.toArray());
                opt.setOptimizationRequest(req);
                int retcode = opt.optimize();
                OptimizationResponse resp = opt.getOptimizationResponse();
                this.setOptimizationResponse(resp);
                return retcode;
            }
            X0 = this.F1.make(this.getDim());
        }
        DoubleMatrix1D doubleMatrix1D = V0 = this.getA() != null ? this.F1.make(this.getA().rows()) : this.F1.make(0);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("X0:  " + ArrayUtils.toString((Object)X0.toArray())));
        }
        DoubleMatrix1D X = X0;
        DoubleMatrix1D V = V0;
        DoubleMatrix1D gradX = null;
        DoubleMatrix2D hessX = null;
        DoubleMatrix1D rDualXV = null;
        DoubleMatrix1D rPriX = null;
        double previousF0X = Double.NaN;
        double previousRPriXNorm = Double.NaN;
        double previousRXVNorm = Double.NaN;
        int iteration = 0;
        while (true) {
            DoubleMatrix1D stepV;
            ++iteration;
            double F0X = this.getF0(X);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("iteration " + iteration));
                this.log.debug((Object)("X=" + ArrayUtils.toString((Object)X.toArray())));
                this.log.debug((Object)("V=" + ArrayUtils.toString((Object)V.toArray())));
                this.log.debug((Object)("f(X)=" + F0X));
            }
            if (this.checkCustomExitConditions(X)) {
                response.setReturnCode(0);
                break;
            }
            gradX = this.getGradF0(X);
            hessX = this.getHessF0(X);
            rDualXV = this.rDual(X, V, gradX);
            rPriX = this.rPri(X);
            double rPriXNorm = Math.sqrt(this.ALG.norm2(rPriX));
            double rDualXVNorm = Math.sqrt(this.ALG.norm2(rDualXV));
            this.log.debug((Object)("rPriXNorm : " + rPriXNorm));
            this.log.debug((Object)("rDualXVNorm: " + rDualXVNorm));
            double rXVNorm = Math.sqrt(Math.pow(rPriXNorm, 2.0) + Math.pow(rDualXVNorm, 2.0));
            if (rPriXNorm <= this.getTolerance() && rXVNorm <= this.getTolerance()) {
                response.setReturnCode(0);
                break;
            }
            if (this.kktSolver == null) {
                this.kktSolver = new BasicKKTSolver();
            }
            if (this.isCheckKKTSolutionAccuracy()) {
                this.kktSolver.setCheckKKTSolutionAccuracy(this.isCheckKKTSolutionAccuracy());
                this.kktSolver.setToleranceKKT(this.getToleranceKKT());
            }
            this.kktSolver.setHMatrix(hessX);
            this.kktSolver.setGVector(rDualXV);
            if (this.getA() != null) {
                this.kktSolver.setAMatrix(this.getA());
                this.kktSolver.setHVector(rPriX);
            }
            DoubleMatrix1D[] sol = this.kktSolver.solve();
            DoubleMatrix1D stepX = sol[0];
            DoubleMatrix1D doubleMatrix1D2 = stepV = sol[1] != null ? sol[1] : this.F1.make(0);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("stepX: " + ArrayUtils.toString((Object)stepX.toArray())));
                this.log.debug((Object)("stepV: " + ArrayUtils.toString((Object)stepV.toArray())));
            }
            if (iteration == this.getMaxIteration()) {
                response.setReturnCode(2);
                this.log.error((Object)"Max iterations limit reached");
                throw new Exception("Max iterations limit reached");
            }
            if (this.isCheckProgressConditions() && !Double.isNaN(previousRPriXNorm) && !Double.isNaN(previousRXVNorm) && (previousRPriXNorm <= rPriXNorm && rPriXNorm >= this.getTolerance() || previousRXVNorm <= rXVNorm && rXVNorm >= this.getTolerance())) {
                this.log.error((Object)"No progress achieved, exit iterations loop without desired accuracy");
                response.setReturnCode(2);
                throw new Exception("No progress achieved, exit iterations loop without desired accuracy");
            }
            previousRPriXNorm = rPriXNorm;
            previousRXVNorm = rXVNorm;
            double s = 1.0;
            DoubleMatrix1D X1 = null;
            DoubleMatrix1D V1 = null;
            DoubleMatrix1D gradX1 = null;
            DoubleMatrix1D rDualX1V1 = null;
            DoubleMatrix1D rPriX1V1 = null;
            double previousNormRX1V1 = Double.NaN;
            while (true) {
                X1 = ColtUtils.add(X, stepX, s);
                V1 = ColtUtils.add(V, stepV, s);
                if (this.isInDomainF0(X1)) {
                    gradX1 = this.getGradF0(X1);
                    rDualX1V1 = this.rDual(X1, V1, gradX1);
                    rPriX1V1 = this.rPri(X1);
                    double normRX1V1 = Math.sqrt(this.ALG.norm2(rDualX1V1) + this.ALG.norm2(rPriX1V1));
                    if (normRX1V1 <= (1.0 - this.getAlpha() * s) * rXVNorm) break;
                    this.log.debug((Object)("normRX1V1: " + normRX1V1));
                    if (!Double.isNaN(previousNormRX1V1) && previousNormRX1V1 <= normRX1V1) {
                        this.log.warn((Object)"No progress achieved in backtracking with norm");
                        break;
                    }
                    previousNormRX1V1 = normRX1V1;
                }
                s = this.getBeta() * s;
            }
            this.log.debug((Object)("s: " + s));
            X = X1;
            V = V1;
        }
        long tStop = System.currentTimeMillis();
        this.log.debug((Object)("time: " + (tStop - tStart)));
        response.setSolution(X.toArray());
        this.setOptimizationResponse(response);
        return response.getReturnCode();
    }

    private DoubleMatrix1D rDual(DoubleMatrix1D X, DoubleMatrix1D V, DoubleMatrix1D gradX) {
        if (this.getA() == null) {
            return gradX;
        }
        return ColtUtils.zMult(this.getAT(), V, gradX, 1.0);
    }

    protected int forwardOptimizationRequest() throws Exception {
        if (this.successor != null) {
            if ("PRIMAL_DUAL_METHOD".equals(this.getInteriorPointMethod())) {
                this.successor = new PrimalDualMethod();
            } else if ("BARRIER_METHOD".equals(this.getInteriorPointMethod())) {
                LogarithmicBarrier bf = new LogarithmicBarrier(this.getFi(), this.getDim());
                this.successor = new BarrierMethod(bf);
            }
        }
        return super.forwardOptimizationRequest();
    }

    public void setKKTSolver(KKTSolver kktSolver) {
        this.kktSolver = kktSolver;
    }
}

