/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.optimizers;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.jet.math.Functions;
import cern.jet.math.Mult;
import com.joptimizer.functions.BarrierFunction;
import com.joptimizer.functions.ConvexMultivariateRealFunction;
import com.joptimizer.functions.FunctionsUtils;
import com.joptimizer.optimizers.BasicPhaseIBM;
import com.joptimizer.optimizers.NewtonLEConstrainedFSP;
import com.joptimizer.optimizers.OptimizationRequest;
import com.joptimizer.optimizers.OptimizationRequestHandler;
import com.joptimizer.optimizers.OptimizationResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BarrierMethod
extends OptimizationRequestHandler {
    private BarrierFunction barrierFunction = null;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public BarrierMethod(BarrierFunction barrierFunction) {
        this.barrierFunction = barrierFunction;
    }

    public int optimize() throws Exception {
        DoubleMatrix1D X;
        OptimizationResponse response;
        long tStart;
        block9: {
            DoubleMatrix1D V0;
            this.log.info((Object)"optimize");
            tStart = System.currentTimeMillis();
            response = new OptimizationResponse();
            DoubleMatrix1D X0 = this.getInitialPoint();
            if (X0 == null) {
                double rPriX0NFNorm;
                DoubleMatrix1D X0NF = this.getNotFeasibleInitialPoint();
                if (X0NF != null && (rPriX0NFNorm = Math.sqrt(this.ALG.norm2(this.rPri(X0NF)))) <= this.getToleranceFeas() && !Double.isNaN(this.barrierFunction.value(X0NF.toArray()))) {
                    this.log.debug((Object)"the provided initial point is already feasible");
                    X0 = X0NF;
                }
                if (X0 == null) {
                    BasicPhaseIBM bf1 = new BasicPhaseIBM(this);
                    X0 = this.F1.make(bf1.findFeasibleInitialPoint());
                }
            }
            double rPriX0Norm = Math.sqrt(this.ALG.norm2(this.rPri(X0)));
            if (Double.isNaN(this.barrierFunction.value(X0.toArray())) || rPriX0Norm > this.getToleranceFeas()) {
                throw new Exception("initial point must be strictly feasible");
            }
            DoubleMatrix1D doubleMatrix1D = V0 = this.getA() != null ? this.F1.make(this.getA().rows()) : this.F1.make(0);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("X0: " + ArrayUtils.toString((Object)X0.toArray())));
                this.log.debug((Object)("V0: " + ArrayUtils.toString((Object)V0.toArray())));
            }
            X = X0;
            final int dim = X.size();
            double t = 1.0;
            int outerIteration = 0;
            do {
                ++outerIteration;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("outerIteration: " + outerIteration));
                    this.log.debug((Object)("X=" + ArrayUtils.toString((Object)X.toArray())));
                    this.log.debug((Object)("f(X)=" + this.getF0(X)));
                }
                double gap = this.barrierFunction.getDualityGap(t);
                this.log.debug((Object)("gap: " + gap));
                if (gap <= this.getTolerance()) break block9;
                if (this.checkCustomExitConditions(X)) {
                    response.setReturnCode(0);
                    break block9;
                }
                final double tIter = t;
                this.log.debug((Object)("t: " + tIter));
                ConvexMultivariateRealFunction newObjectiveFunction = new ConvexMultivariateRealFunction(){

                    public double value(double[] X) {
                        DoubleMatrix1D x = BarrierMethod.this.F1.make(X);
                        double phi = BarrierMethod.this.barrierFunction.value(X);
                        return tIter * BarrierMethod.this.getF0(x) + phi;
                    }

                    public double[] gradient(double[] X) {
                        DoubleMatrix1D x = BarrierMethod.this.F1.make(X);
                        DoubleMatrix1D phiGrad = BarrierMethod.this.F1.make(BarrierMethod.this.barrierFunction.gradient(X));
                        return BarrierMethod.this.getGradF0(x).assign(Mult.mult(tIter)).assign(phiGrad, Functions.plus).toArray();
                    }

                    public double[][] hessian(double[] X) {
                        DoubleMatrix1D x = BarrierMethod.this.F1.make(X);
                        DoubleMatrix2D hessF0X = BarrierMethod.this.getHessF0(x);
                        double[][] hessX = BarrierMethod.this.barrierFunction.hessian(X);
                        if (hessX == FunctionsUtils.ZEROES_2D_ARRAY_PLACEHOLDER) {
                            return hessF0X.assign(Mult.mult(tIter)).toArray();
                        }
                        DoubleMatrix2D phiHess = BarrierMethod.this.F2.make(hessX);
                        return hessF0X.assign(Mult.mult(tIter)).assign(phiHess, Functions.plus).toArray();
                    }

                    public int getDim() {
                        return dim;
                    }
                };
                OptimizationRequest or = new OptimizationRequest();
                or.setA(this.getA() != null ? this.getA().toArray() : (double[][])null);
                or.setAlpha(this.getAlpha());
                or.setB(this.getB() != null ? this.getB().toArray() : null);
                or.setBeta(this.getBeta());
                or.setCheckKKTSolutionAccuracy(this.isCheckKKTSolutionAccuracy());
                or.setCheckProgressConditions(this.isCheckProgressConditions());
                or.setF0(newObjectiveFunction);
                or.setInitialPoint(X.toArray());
                or.setMaxIteration(this.getMaxIteration());
                or.setMu(this.getMu());
                or.setTolerance(this.getToleranceInnerStep());
                or.setToleranceKKT(this.getToleranceKKT());
                BarrierNewtonLEConstrainedFSP opt = new BarrierNewtonLEConstrainedFSP(true, this);
                opt.setOptimizationRequest(or);
                if (opt.optimize() == 2) {
                    response.setReturnCode(2);
                    break block9;
                }
                OptimizationResponse newtonResponse = opt.getOptimizationResponse();
                X = this.F1.make(newtonResponse.getSolution());
                t = this.getMu() * t;
            } while (outerIteration != this.getMaxIteration());
            response.setReturnCode(2);
            this.log.error((Object)"Max iterations limit reached");
            throw new Exception("Max iterations limit reached");
        }
        long tStop = System.currentTimeMillis();
        this.log.debug((Object)("time: " + (tStop - tStart)));
        response.setSolution(X.toArray());
        this.setOptimizationResponse(response);
        return response.getReturnCode();
    }

    protected DoubleMatrix1D getFi(DoubleMatrix1D X) {
        throw new UnsupportedOperationException();
    }

    protected DoubleMatrix2D getGradFi(DoubleMatrix1D X) {
        throw new UnsupportedOperationException();
    }

    protected DoubleMatrix2D[] getHessFi(DoubleMatrix1D X) {
        throw new UnsupportedOperationException();
    }

    protected BarrierFunction getBarrierFunction() {
        return this.barrierFunction;
    }

    private class BarrierNewtonLEConstrainedFSP
    extends NewtonLEConstrainedFSP {
        BarrierMethod father;

        public BarrierNewtonLEConstrainedFSP(boolean activateChain, BarrierMethod father) {
            super(activateChain);
            this.father = null;
            this.father = father;
        }

        protected boolean checkCustomExitConditions(DoubleMatrix1D Y) {
            boolean ret = this.father.checkCustomExitConditions(Y);
            BarrierMethod.this.log.debug((Object)("checkCustomExitConditions: " + ret));
            return ret;
        }
    }
}

