/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.algebra;

import cern.colt.function.IntIntDoubleFunction;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import com.joptimizer.algebra.MatrixRescaler;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;

public class MatrixLogSumRescaler
implements MatrixRescaler {
    private double base = 10.0;
    private Logger logger = Logger.getLogger((String)this.getClass().getName());

    public MatrixLogSumRescaler() {
    }

    public MatrixLogSumRescaler(double base) {
        this.base = base;
    }

    public DoubleMatrix1D[] getMatrixScalingFactors(DoubleMatrix2D A) {
        int k;
        int k2;
        int m = A.rows();
        int n = A.columns();
        final double log10_b = Math.log10(this.base);
        final int[] R = new int[m];
        final int[] C = new int[n];
        final double[] t = new double[1];
        final double[] a = new double[m];
        final double[] b = new double[n];
        final boolean[][] Z = new boolean[m][n];
        A.forEachNonZero(new IntIntDoubleFunction(){

            public double apply(int i, int j, double aij) {
                R[i] = R[i] + 1;
                C[j] = C[j] + 1;
                Z[i][j] = true;
                t[0] = -(Math.log10(Math.abs(aij)) / log10_b + 0.5);
                a[i] = a[i] + t[0];
                b[j] = b[j] + t[0];
                return aij;
            }
        });
        for (int i = 0; i < m; ++i) {
            a[i] = a[i] / (double)R[i];
        }
        for (int j = 0; j < n; ++j) {
            b[j] = b[j] / (double)C[j];
        }
        int[] xx = new int[m];
        int[] yy = new int[n];
        int[] previousXX = null;
        int[] previousYY = null;
        boolean stopX = false;
        boolean stopY = false;
        int maxIteration = 3;
        int l = 0;
        for (l = 0; !(l > maxIteration || stopX && stopY); ++l) {
            boolean allEquals;
            int j;
            int i;
            double[] tt = new double[m];
            System.arraycopy(a, 0, tt, 0, m);
            for (i = 0; i < m; ++i) {
                for (j = 0; j < n; ++j) {
                    boolean[] ZI = Z[i];
                    if (!ZI[j]) continue;
                    tt[i] = tt[i] - (double)yy[j] / (double)R[i];
                }
            }
            for (k2 = 0; k2 < m; ++k2) {
                xx[k2] = (int)Math.round(tt[k2]);
            }
            if (previousXX == null) {
                previousXX = xx;
            } else {
                allEquals = true;
                for (k = 0; k < m && allEquals; ++k) {
                    allEquals = xx[k] == previousXX[k];
                }
                stopX = allEquals;
                previousXX = xx;
            }
            tt = new double[n];
            System.arraycopy(b, 0, tt, 0, n);
            for (i = 0; i < m; ++i) {
                for (j = 0; j < n; ++j) {
                    if (!Z[i][j]) continue;
                    tt[j] = tt[j] - (double)xx[i] / (double)C[j];
                }
            }
            for (k2 = 0; k2 < n; ++k2) {
                yy[k2] = (int)Math.round(tt[k2]);
            }
            if (previousYY == null) {
                previousYY = yy;
                continue;
            }
            allEquals = true;
            for (k = 0; k < n && allEquals; ++k) {
                allEquals = yy[k] == previousYY[k];
            }
            stopY = allEquals;
            previousYY = yy;
        }
        if (l == maxIteration) {
            // empty if block
        }
        this.logger.debug((Object)("xx: " + ArrayUtils.toString((Object)xx)));
        this.logger.debug((Object)("yy: " + ArrayUtils.toString((Object)yy)));
        DenseDoubleMatrix1D u = new DenseDoubleMatrix1D(m);
        for (k2 = 0; k2 < m; ++k2) {
            ((DoubleMatrix1D)u).setQuick(k2, Math.pow(this.base, xx[k2]));
        }
        DenseDoubleMatrix1D v = new DenseDoubleMatrix1D(n);
        for (k = 0; k < n; ++k) {
            ((DoubleMatrix1D)v).setQuick(k, Math.pow(this.base, yy[k]));
        }
        DoubleMatrix1D[] ret = new DoubleMatrix1D[]{u, v};
        return ret;
    }

    public DoubleMatrix1D getMatrixScalingFactorsSymm(DoubleMatrix2D A) {
        int n = A.rows();
        final double log10_b = Math.log10(this.base);
        final int[] x = new int[n];
        final double[] cHolder = new double[1];
        final double[] tHolder = new double[1];
        final int[] currentColumnIndexHolder = new int[]{-1};
        IntIntDoubleFunction myFunct = new IntIntDoubleFunction(){

            public double apply(int i, int j, double pij) {
                int currentColumnIndex = currentColumnIndexHolder[0];
                if (i == currentColumnIndex) {
                    tHolder[0] = tHolder[0] - 0.5 * (Math.log10(Math.abs(pij)) / log10_b + 0.5);
                    cHolder[0] = cHolder[0] + 1.0;
                } else if (i > currentColumnIndex) {
                    tHolder[0] = tHolder[0] - 2.0 * (Math.log10(Math.abs(pij)) / log10_b + 0.5) - (double)(2 * x[i]);
                    cHolder[0] = cHolder[0] + 2.0;
                }
                return pij;
            }
        };
        for (int currentColumnIndex = n - 1; currentColumnIndex >= 0; --currentColumnIndex) {
            cHolder[0] = 0.0;
            tHolder[0] = 0.0;
            currentColumnIndexHolder[0] = currentColumnIndex;
            DoubleMatrix2D P = A.viewPart(0, currentColumnIndex, n, 1);
            P.forEachNonZero(myFunct);
            if (!(cHolder[0] > 0.0)) continue;
            x[currentColumnIndex] = (int)Math.round(tHolder[0] / cHolder[0]);
        }
        DenseDoubleMatrix1D u = new DenseDoubleMatrix1D(n);
        for (int k = 0; k < n; ++k) {
            ((DoubleMatrix1D)u).setQuick(k, Math.pow(this.base, x[k]));
        }
        return u;
    }

    public boolean checkScaling(DoubleMatrix2D A, final DoubleMatrix1D U, final DoubleMatrix1D V) {
        final double log10_2 = Math.log10(this.base);
        final double[] originalOFValue = new double[]{0.0};
        final double[] scaledOFValue = new double[]{0.0};
        final double[] x = new double[A.rows()];
        final double[] y = new double[A.columns()];
        A.forEachNonZero(new IntIntDoubleFunction(){

            public double apply(int i, int j, double aij) {
                double v = Math.log10(Math.abs(aij)) / log10_2 + 0.5;
                originalOFValue[0] = originalOFValue[0] + Math.pow(v, 2.0);
                double xi = Math.log10(U.getQuick(i)) / log10_2;
                double yj = Math.log10(V.getQuick(j)) / log10_2;
                scaledOFValue[0] = scaledOFValue[0] + Math.pow(xi + yj + v, 2.0);
                x[i] = xi;
                y[j] = yj;
                return aij;
            }
        });
        originalOFValue[0] = 0.5 * originalOFValue[0];
        scaledOFValue[0] = 0.5 * scaledOFValue[0];
        this.logger.debug((Object)("x: " + ArrayUtils.toString((Object)x)));
        this.logger.debug((Object)("y: " + ArrayUtils.toString((Object)y)));
        this.logger.debug((Object)("originalOFValue: " + originalOFValue[0]));
        this.logger.debug((Object)("scaledOFValue  : " + scaledOFValue[0]));
        return !(originalOFValue[0] < scaledOFValue[0]);
    }
}

