/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.algebra;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Property;
import com.joptimizer.algebra.MatrixRescaler;
import com.joptimizer.util.ColtUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;

public class LDLTPermutedFactorization {
    private int dim;
    private DoubleMatrix2D Q;
    private int mode;
    private MatrixRescaler rescaler = null;
    private DoubleMatrix1D U;
    public static final int DIAGONAL_PIVOLTING = 0;
    public static final int DIAGONAL_PIVOLTING_WITH_PARTIAL_PIVOTING = 1;
    protected Algebra ALG = Algebra.DEFAULT;
    protected DoubleFactory2D F2 = DoubleFactory2D.dense;
    protected DoubleFactory1D F1 = DoubleFactory1D.dense;
    private DoubleMatrix2D P;
    private DoubleMatrix2D D;
    private DoubleMatrix2D L;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public LDLTPermutedFactorization(DoubleMatrix2D Q) throws Exception {
        this(Q, 1, null);
    }

    public LDLTPermutedFactorization(DoubleMatrix2D Q, int mode) throws Exception {
        this(Q, mode, null);
    }

    public LDLTPermutedFactorization(DoubleMatrix2D Q, MatrixRescaler rescaler) throws Exception {
        this(Q, 1, rescaler);
    }

    public LDLTPermutedFactorization(DoubleMatrix2D Q, int mode, MatrixRescaler rescaler) throws Exception {
        this.dim = Q.rows();
        this.Q = Q;
        this.mode = mode;
        this.rescaler = rescaler;
    }

    public void factorize() throws Exception {
        this.factorize(false);
    }

    public void factorize(boolean checkSymmetry) throws Exception {
        if (checkSymmetry && !Property.TWELVE.isSymmetric(this.Q)) {
            throw new Exception("Matrix is not symmetric");
        }
        if (this.rescaler != null) {
            boolean checkOK;
            double[] cn_00_original = null;
            double[] cn_2_original = null;
            double[] cn_00_scaled = null;
            double[] cn_2_scaled = null;
            if (this.log.isDebugEnabled()) {
                cn_00_original = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q).toArray()), Integer.MAX_VALUE);
                this.log.debug((Object)("cn_00_original Q before scaling: " + ArrayUtils.toString((Object)cn_00_original)));
                cn_2_original = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q).toArray()), 2);
                this.log.debug((Object)("cn_2_original Q before scaling : " + ArrayUtils.toString((Object)cn_2_original)));
            }
            DoubleMatrix1D Uv = this.rescaler.getMatrixScalingFactorsSymm(this.Q);
            if (this.log.isDebugEnabled() && !(checkOK = this.rescaler.checkScaling(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q), Uv, Uv))) {
                this.log.warn((Object)"Scaling failed (checkScaling = false)");
            }
            this.U = Uv;
            this.Q = ColtUtils.diagonalMatrixMult(Uv, this.Q, Uv);
            if (this.log.isDebugEnabled()) {
                cn_00_scaled = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q).toArray()), Integer.MAX_VALUE);
                this.log.debug((Object)("cn_00_scaled Q after scaling : " + ArrayUtils.toString((Object)cn_00_scaled)));
                cn_2_scaled = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q).toArray()), 2);
                this.log.debug((Object)("cn_2_scaled Q after scaling  : " + ArrayUtils.toString((Object)cn_2_scaled)));
                if (cn_00_original[0] < cn_00_scaled[0] || cn_2_original[0] < cn_2_scaled[0]) {
                    this.log.warn((Object)"Problematic scaling");
                }
            }
        }
        switch (this.mode) {
            case 0: {
                this.pldltpt();
                break;
            }
            case 1: {
                this.pldltptBK();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown mode " + this.mode);
            }
        }
    }

    private void pldltpt() throws Exception {
        DoubleMatrix2D S = this.rescaler == null ? this.Q.copy() : this.Q;
        int n = S.rows();
        DoubleMatrix2D A = S.copy();
        this.P = DoubleFactory2D.sparse.identity(n);
        this.D = DoubleFactory2D.sparse.make(n, n);
        this.L = DoubleFactory2D.sparse.make(n, n);
        DoubleMatrix2D LT = this.ALG.transpose(this.L);
        int s = 0;
        for (int j = 0; j < n; ++j) {
            int r;
            DoubleMatrix2D LPart = null;
            DoubleMatrix2D LTPart = null;
            DoubleMatrix2D APart = null;
            DoubleMatrix2D DPart = null;
            double ajj = A.getQuick(j, j);
            if (Math.abs(ajj) > 1.0E-16) {
                this.D.setQuick(j, j, ajj);
                s = 1;
            } else {
                int k = -1;
                for (r = j + 1; r < n; ++r) {
                    if (!(Math.abs(A.getQuick(r, j)) > 1.0E-16)) continue;
                    k = r;
                    break;
                }
                if (k < 0) {
                    throw new Exception("singular matrix");
                }
                A = ColtUtils.symmPermutation(A, k, j + 1);
                this.P.setQuick(k, k, 0.0);
                this.P.setQuick(j + 1, j + 1, 0.0);
                this.P.setQuick(k, j + 1, 1.0);
                this.P.setQuick(j + 1, k, 1.0);
                this.D.setQuick(j, j, A.getQuick(j, j));
                this.D.setQuick(j, j + 1, A.getQuick(j, j + 1));
                this.D.setQuick(j + 1, j, A.getQuick(j + 1, j));
                this.D.setQuick(j + 1, j + 1, A.getQuick(j + 1, j + 1));
                s = 2;
            }
            APart = A.viewPart(j, j, n - j, 1 + s - 1);
            DPart = this.ALG.inverse(this.D.viewPart(j, j, 1 + s - 1, 1 + s - 1));
            LPart = this.L.viewPart(j, j, n - j, 1 + s - 1);
            DoubleMatrix2D AD = this.ALG.mult(APart, DPart);
            for (r = 0; r < LPart.rows(); ++r) {
                for (int c = 0; c < LPart.columns(); ++c) {
                    LPart.setQuick(r, c, AD.getQuick(r, c));
                }
            }
            LPart = this.L.viewPart(j + s - 1, j, n - (j + s - 1), 1 + s - 1);
            DPart = this.D.viewPart(j, j, 1 + s - 1, 1 + s - 1);
            LTPart = LT.viewPart(j, j + s - 1, s, n - (j + s - 1));
            APart = A.viewPart(j + s - 1, j + s - 1, n - (j + s - 1), n - (j + s - 1));
            DoubleMatrix2D LDLT = this.ALG.mult(LPart, this.ALG.mult(DPart, LTPart));
            for (int r2 = 0; r2 < APart.rows(); ++r2) {
                for (int c = 0; c < APart.columns(); ++c) {
                    APart.setQuick(r2, c, APart.getQuick(r2, c) - LDLT.getQuick(r2, c));
                }
            }
            j = j + s - 1;
        }
    }

    private void pldltptBK() throws Exception {
        DoubleMatrix2D S = this.rescaler == null ? this.Q.copy() : this.Q;
        int n = S.rows();
        DoubleMatrix2D A = S.copy();
        this.P = DoubleFactory2D.sparse.identity(n);
        this.D = DoubleFactory2D.sparse.make(n, n);
        this.L = DoubleFactory2D.sparse.make(n, n);
        DoubleMatrix2D LT = this.ALG.transpose(this.L);
        double mu = (1.0 + Math.sqrt(17.0)) / 8.0;
        int s = 0;
        for (int j = 0; j < n; ++j) {
            DoubleMatrix2D LPart = null;
            DoubleMatrix2D LTPart = null;
            DoubleMatrix2D APart = null;
            DoubleMatrix2D DPart = null;
            double lambda = -1.0;
            int r = -1;
            for (int rr = j + 1; rr < n; ++rr) {
                double d = Math.abs(A.getQuick(rr, j));
                if (!(d > lambda)) continue;
                lambda = d;
                r = rr;
            }
            double ajj = A.getQuick(j, j);
            if (Math.abs(ajj) > mu * lambda) {
                this.D.setQuick(j, j, ajj);
                s = 1;
            } else {
                double sigma = -1.0;
                int p = -1;
                for (int rr = 0; rr < n; ++rr) {
                    double d;
                    if (rr == r || !((d = Math.abs(A.getQuick(rr, r))) > sigma)) continue;
                    sigma = d;
                    p = rr;
                }
                if (sigma * Math.abs(ajj) > mu * lambda * lambda) {
                    this.D.setQuick(j, j, A.getQuick(j, j));
                    s = 1;
                } else if (Math.abs(A.getQuick(r, r)) > mu * sigma) {
                    A = ColtUtils.symmPermutation(A, r, j);
                    this.P.setQuick(r, r, 0.0);
                    this.P.setQuick(j, j, 0.0);
                    this.P.setQuick(r, j, 1.0);
                    this.P.setQuick(j, r, 1.0);
                    this.D.setQuick(j, j, A.getQuick(j, j));
                    s = 1;
                } else {
                    int t = j + 1;
                    A = ColtUtils.symmPermutation(A, r, t);
                    this.P.setQuick(r, r, 0.0);
                    this.P.setQuick(t, t, 0.0);
                    this.P.setQuick(r, t, 1.0);
                    this.P.setQuick(t, r, 1.0);
                    this.D.setQuick(j, j, A.getQuick(j, j));
                    this.D.setQuick(j, j + 1, A.getQuick(j, j + 1));
                    this.D.setQuick(j + 1, j, A.getQuick(j + 1, j));
                    this.D.setQuick(j + 1, j + 1, A.getQuick(j + 1, j + 1));
                    s = 2;
                }
            }
            APart = A.viewPart(j, j, n - j, 1 + s - 1);
            DPart = this.ALG.inverse(this.D.viewPart(j, j, 1 + s - 1, 1 + s - 1));
            LPart = this.L.viewPart(j, j, n - j, 1 + s - 1);
            DoubleMatrix2D AD = this.ALG.mult(APart, DPart);
            for (int rr = 0; rr < LPart.rows(); ++rr) {
                for (int cc = 0; cc < LPart.columns(); ++cc) {
                    LPart.setQuick(rr, cc, AD.getQuick(rr, cc));
                }
            }
            LPart = this.L.viewPart(j + s - 1, j, n - (j + s - 1), 1 + s - 1);
            DPart = this.D.viewPart(j, j, 1 + s - 1, 1 + s - 1);
            LTPart = LT.viewPart(j, j + s - 1, s, n - (j + s - 1));
            APart = A.viewPart(j + s - 1, j + s - 1, n - (j + s - 1), n - (j + s - 1));
            DoubleMatrix2D LDLT = this.ALG.mult(LPart, this.ALG.mult(DPart, LTPart));
            for (int rr = 0; rr < APart.rows(); ++rr) {
                for (int cc = 0; cc < APart.columns(); ++cc) {
                    APart.setQuick(rr, cc, APart.getQuick(rr, cc) - LDLT.getQuick(rr, cc));
                }
            }
            j = j + s - 1;
        }
    }

    public DoubleMatrix1D solve(DoubleMatrix1D b) {
        if (b.size() != this.dim) {
            this.log.error((Object)("wrong dimension of vector b: expected " + this.dim + ", actual " + b.size()));
            throw new RuntimeException("wrong dimension of vector b: expected " + this.dim + ", actual " + b.size());
        }
        throw new RuntimeException("not yet implemented");
    }

    public DoubleMatrix2D solve(DoubleMatrix2D B) {
        if (B.rows() != this.dim) {
            this.log.error((Object)("wrong dimension of vector b: expected " + this.dim + ", actual " + B.rows()));
            throw new RuntimeException("wrong dimension of vector b: expected " + this.dim + ", actual " + B.rows());
        }
        throw new RuntimeException("not yet implemented");
    }

    public DoubleMatrix2D getP() {
        if (this.rescaler == null) {
            return this.P;
        }
        throw new RuntimeException("not yet implemented");
    }

    public DoubleMatrix2D getD() {
        if (this.rescaler == null) {
            return this.D;
        }
        throw new RuntimeException("not yet implemented");
    }

    public DoubleMatrix2D getL() {
        if (this.rescaler == null) {
            return this.L;
        }
        throw new RuntimeException("not yet implemented");
    }

    public DoubleMatrix2D getLT() {
        if (this.rescaler == null) {
            return this.ALG.transpose(this.L);
        }
        throw new RuntimeException("not yet implemented");
    }
}

