/*
 * Decompiled with CFR 0.152.
 */
package org.joml.internal;

public final class Runtime {
    public static final boolean HAS_floatToRawIntBits = Runtime.hasFloatToRawIntBits();
    public static final boolean HAS_doubleToRawLongBits = Runtime.hasDoubleToRawLongBits();
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    private Runtime() {
    }

    private static boolean hasFloatToRawIntBits() {
        try {
            (class$java$lang$Float == null ? (class$java$lang$Float = Runtime.class$("java.lang.Float")) : class$java$lang$Float).getDeclaredMethod("floatToRawIntBits", Float.TYPE);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static boolean hasDoubleToRawLongBits() {
        try {
            (class$java$lang$Double == null ? (class$java$lang$Double = Runtime.class$("java.lang.Double")) : class$java$lang$Double).getDeclaredMethod("doubleToRawLongBits", Double.TYPE);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static int floatToIntBits(float flt) {
        if (HAS_floatToRawIntBits) {
            return Runtime.floatToIntBits1_3(flt);
        }
        return Runtime.floatToIntBits1_2(flt);
    }

    private static int floatToIntBits1_3(float flt) {
        return Float.floatToRawIntBits(flt);
    }

    private static int floatToIntBits1_2(float flt) {
        return Float.floatToIntBits(flt);
    }

    public static long doubleToLongBits(double dbl) {
        if (HAS_doubleToRawLongBits) {
            return Runtime.doubleToLongBits1_3(dbl);
        }
        return Runtime.doubleToLongBits1_2(dbl);
    }

    private static long doubleToLongBits1_3(double dbl) {
        return Double.doubleToRawLongBits(dbl);
    }

    private static long doubleToLongBits1_2(double dbl) {
        return Double.doubleToLongBits(dbl);
    }

    public static String formatNumbers(String str) {
        StringBuffer res = new StringBuffer();
        int eIndex = Integer.MIN_VALUE;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == 'E') {
                eIndex = i;
            } else {
                if (c == ' ' && eIndex == i - 1) {
                    res.append('+');
                    continue;
                }
                if (Character.isDigit(c) && eIndex == i - 1) {
                    res.append('+');
                }
            }
            res.append(c);
        }
        return res.toString();
    }

    private static int compare(float f1, float f2) {
        int anotherBits;
        if (f1 < f2) {
            return -1;
        }
        if (f1 > f2) {
            return 1;
        }
        int thisBits = Float.floatToIntBits(f1);
        return thisBits == (anotherBits = Float.floatToIntBits(f2)) ? 0 : (thisBits < anotherBits ? -1 : 1);
    }

    private static int compare(double d1, double d2) {
        long anotherBits;
        if (d1 < d2) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        long thisBits = Double.doubleToLongBits(d1);
        return thisBits == (anotherBits = Double.doubleToLongBits(d2)) ? 0 : (thisBits < anotherBits ? -1 : 1);
    }

    public static boolean equals(float a, float b, float delta) {
        if (Runtime.compare(a, b) == 0) {
            return true;
        }
        return !(Math.abs(a - b) > delta);
    }

    public static boolean equals(double a, double b, double delta) {
        if (Runtime.compare(a, b) == 0) {
            return true;
        }
        return !(Math.abs(a - b) > delta);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

