/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2fc;
import org.joml.internal.Options;
import org.joml.internal.Runtime;

public class Rectangled
implements Externalizable {
    public double minX;
    public double minY;
    public double maxX;
    public double maxY;

    public Rectangled() {
    }

    public Rectangled(Rectangled source) {
        this.minX = source.minX;
        this.minY = source.minY;
        this.maxX = source.maxX;
        this.maxY = source.maxY;
    }

    public Rectangled(Vector2dc min, Vector2dc max) {
        this.minX = min.x();
        this.minY = min.y();
        this.maxX = max.x();
        this.maxY = max.y();
    }

    public Rectangled(double minX, double minY, double maxX, double maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public boolean intersects(Rectangled other) {
        return this.minX < other.maxX && this.maxX >= other.minX && this.maxY >= other.minY && this.minY < other.maxY;
    }

    public boolean contains(Vector2d point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(double x, double y) {
        return x >= this.minX && y >= this.minX && x < this.maxX && y < this.maxY;
    }

    public Rectangled translate(Vector2dc xy) {
        return this.translate(xy.x(), xy.y(), this);
    }

    public Rectangled translate(Vector2dc xy, Rectangled dest) {
        return this.translate(xy.x(), xy.y(), dest);
    }

    public Rectangled translate(Vector2fc xy) {
        return this.translate(xy.x(), xy.y(), this);
    }

    public Rectangled translate(Vector2fc xy, Rectangled dest) {
        return this.translate(xy.x(), xy.y(), dest);
    }

    public Rectangled translate(double x, double y) {
        return this.translate(x, y, this);
    }

    public Rectangled translate(double x, double y, Rectangled dest) {
        dest.minX = this.minX + x;
        dest.minY = this.minY + y;
        dest.maxX = this.maxX + x;
        dest.maxY = this.maxY + y;
        return dest;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.maxX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rectangled other = (Rectangled)obj;
        if (Double.doubleToLongBits(this.maxX) != Double.doubleToLongBits(other.maxX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxY) != Double.doubleToLongBits(other.maxY)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minX) != Double.doubleToLongBits(other.minX)) {
            return false;
        }
        return Double.doubleToLongBits(this.minY) == Double.doubleToLongBits(other.minY);
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.minX) + " " + formatter.format(this.minY) + ") < (" + formatter.format(this.maxX) + " " + formatter.format(this.maxY) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.minX);
        out.writeDouble(this.minY);
        out.writeDouble(this.maxX);
        out.writeDouble(this.maxY);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.minX = in.readDouble();
        this.minY = in.readDouble();
        this.maxX = in.readDouble();
        this.maxY = in.readDouble();
    }
}

