/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.referencepoints;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.referencepoints.ReferencePointsHeuristic;
import java.util.ArrayList;
import java.util.Collection;

public class StarBasedReferencePoints
implements ReferencePointsHeuristic {
    protected boolean nocenter;
    protected double scale;

    public StarBasedReferencePoints(boolean bl, double d) {
        this.nocenter = bl;
        this.scale = d;
    }

    @Override
    public Collection<? extends NumberVector> getReferencePoints(Relation<? extends NumberVector> relation) {
        int n = RelationUtil.dimensionality(relation);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = 0.0;
            dArray2[i] = Double.MAX_VALUE;
            dArray3[i] = -1.7976931348623157E308;
        }
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            NumberVector numberVector = relation.get(dBIDIter);
            for (int i = 0; i < n; ++i) {
                double d = numberVector.doubleValue(i);
                int n2 = i;
                dArray[n2] = dArray[n2] + d;
                dArray2[i] = Math.min(dArray2[i], d);
                dArray3[i] = Math.max(dArray3[i], d);
            }
            dBIDIter.advance();
        }
        for (int i = 0; i < n; ++i) {
            dArray[i] = dArray[i] / (double)relation.size();
            dArray2[i] = (dArray2[i] - dArray[i]) * this.scale + dArray[i];
            dArray3[i] = (dArray3[i] - dArray[i]) * this.scale + dArray[i];
        }
        ArrayList<Vector> arrayList = new ArrayList<Vector>(2 * n + 1);
        if (!this.nocenter) {
            arrayList.add(new Vector(dArray));
        }
        for (int i = 0; i < n; ++i) {
            double[] dArray4 = (double[])dArray.clone();
            dArray4[i] = dArray2[i];
            arrayList.add(new Vector(dArray4));
            dArray4 = (double[])dArray.clone();
            dArray4[i] = dArray3[i];
            arrayList.add(new Vector(dArray4));
        }
        return arrayList;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID NOCENTER_ID = new OptionID("star.nocenter", "Do not use the center as extra reference point.");
        public static final OptionID SCALE_ID = new OptionID("star.scale", "Scale the reference points by the given factor. This can be used to obtain reference points outside the used data space.");
        protected boolean nocenter;
        protected double scale;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            Flag flag = new Flag(NOCENTER_ID);
            if (parameterization.grab(flag)) {
                this.nocenter = (Boolean)flag.getValue();
            }
            if (parameterization.grab(doubleParameter = (DoubleParameter)new DoubleParameter(SCALE_ID, 1.0).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE))) {
                this.scale = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected StarBasedReferencePoints makeInstance() {
            return new StarBasedReferencePoints(this.nocenter, this.scale);
        }
    }
}

