/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.referencepoints;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.referencepoints.ReferencePointsHeuristic;
import java.util.ArrayList;
import java.util.Collection;

public class GridBasedReferencePoints
implements ReferencePointsHeuristic {
    private static final Logging LOG = Logging.getLogger(GridBasedReferencePoints.class);
    protected int gridres;
    protected double gridscale;

    public GridBasedReferencePoints(int n, double d) {
        this.gridres = n;
        this.gridscale = d;
    }

    @Override
    public Collection<? extends NumberVector> getReferencePoints(Relation<? extends NumberVector> relation) {
        int n;
        double[][] dArray = RelationUtil.computeMinMax(relation);
        int n2 = dArray[0].length;
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray2[n] = (dArray[0][n] + dArray[1][n]) * 0.5;
        }
        if (this.gridres <= 0) {
            LOG.warning("Grid of resolution " + this.gridres + " will have a single point only.");
            ArrayList<Vector> arrayList = new ArrayList<Vector>(1);
            arrayList.add(new Vector(dArray2));
            return arrayList;
        }
        n = this.gridres + 1;
        int n3 = MathUtil.ipowi(n, n2);
        if (n3 < 0) {
            throw new AbortException("Grids with more than 2^31 are not supported, or meaningful.");
        }
        if (n3 < 0 || n3 > relation.size()) {
            LOG.warning("Grid has " + n3 + " points, but you only have " + relation.size() + " observations.");
        }
        ArrayList<Vector> arrayList = new ArrayList<Vector>(n3);
        double[] dArray3 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray3[i] = (dArray[1][i] - dArray[0][i]) / (double)this.gridres;
        }
        double d = (double)this.gridres * 0.5;
        for (int i = 0; i < n3; ++i) {
            double[] dArray4 = new double[n2];
            int n4 = i;
            for (int j = 0; j < n2; ++j) {
                int n5 = n4 % n;
                n4 /= n;
                dArray4[j] = dArray2[j] + ((double)n5 - d) * dArray3[j] * this.gridscale;
            }
            arrayList.add(new Vector(dArray4));
        }
        return arrayList;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID GRID_ID = new OptionID("grid.size", "The number of partitions in each dimension. Points will be placed on the edges of the grid, except for a grid size of 0, where only the mean is generated as reference point.");
        public static final OptionID GRID_SCALE_ID = new OptionID("grid.scale", "Scale the grid by the given factor. This can be used to obtain reference points outside the used data space.");
        protected int gridres;
        protected double gridscale;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(GRID_ID, 1);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (parameterization.grab(intParameter)) {
                this.gridres = (Integer)intParameter.getValue();
            }
            DoubleParameter doubleParameter = new DoubleParameter(GRID_SCALE_ID, 1.0);
            doubleParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.gridscale = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected GridBasedReferencePoints makeInstance() {
            return new GridBasedReferencePoints(this.gridres, this.gridscale);
        }
    }
}

