/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ListParameter;

public class IntListParameter
extends ListParameter<IntListParameter, int[]> {
    public IntListParameter(OptionID optionID, boolean bl) {
        super(optionID, bl);
    }

    public IntListParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        int[] nArray = (int[])this.getValue();
        if (nArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(nArray[0]);
        for (int i = 1; i < nArray.length; ++i) {
            stringBuilder.append(",");
            stringBuilder.append(nArray[i]);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getDefaultValueAsString() {
        int[] nArray = (int[])this.getDefaultValue();
        if (nArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(nArray[0]);
        for (int i = 1; i < nArray.length; ++i) {
            stringBuilder.append(",");
            stringBuilder.append(nArray[i]);
        }
        return stringBuilder.toString();
    }

    @Override
    protected int[] parseValue(Object object) throws ParameterException {
        if (object instanceof int[]) {
            return (int[])object;
        }
        if (object instanceof String) {
            String[] stringArray = SPLIT.split((String)object);
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = Integer.valueOf(stringArray[i]);
            }
            return nArray;
        }
        if (object instanceof Integer) {
            return new int[]{(Integer)object};
        }
        throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getName() + "\" requires a list of Integer values!");
    }

    @Override
    public int size() {
        return ((int[])this.getValue()).length;
    }

    @Override
    public String getSyntax() {
        return "<int_1,...,int_n>";
    }

    public long[] getValueAsBitSet() {
        int[] nArray = (int[])this.getValue();
        int n = 0;
        for (int n2 : nArray) {
            n = n2 > n ? n2 : n;
        }
        long[] lArray = new long[(n >>> 6) + 1];
        for (int n3 : nArray) {
            int n4 = n3 >>> 6;
            lArray[n4] = lArray[n4] | 1L << (n3 & 0x3F);
        }
        return lArray;
    }
}

