/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.AbstractParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ListParameterization
extends AbstractParameterization {
    List<ParameterPair> parameters = new LinkedList<ParameterPair>();

    public ListParameterization() {
    }

    public ListParameterization(Collection<ParameterPair> collection) {
        this();
        this.parameters = new LinkedList<ParameterPair>();
        for (ParameterPair parameterPair : collection) {
            this.addParameter(parameterPair.option, parameterPair.value);
        }
    }

    public void addFlag(OptionID optionID) {
        this.parameters.add(new ParameterPair(optionID, "true"));
    }

    public void addParameter(OptionID optionID, Object object) {
        this.parameters.add(new ParameterPair(optionID, object));
    }

    public void forwardOption(Flag flag) {
        if (flag.isDefined() && ((Boolean)flag.getValue()).booleanValue()) {
            this.addFlag(flag.getOptionID());
        }
    }

    public void forwardOption(Parameter<?> parameter) {
        if (parameter.isDefined()) {
            this.addParameter(parameter.getOptionID(), parameter.getValue());
        }
    }

    @Override
    public boolean setValueForOption(Parameter<?> parameter) throws ParameterException {
        Iterator<ParameterPair> iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            ParameterPair parameterPair = iterator.next();
            if (parameterPair.option != parameter.getOptionID()) continue;
            iterator.remove();
            parameter.setValue(parameterPair.value);
            return true;
        }
        return false;
    }

    public List<ParameterPair> getRemainingParameters() {
        return this.parameters;
    }

    @Override
    public boolean hasUnusedParameters() {
        return this.parameters.size() > 0;
    }

    @Override
    public Parameterization descend(Object object) {
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ParameterPair parameterPair : this.parameters) {
            stringBuilder.append('-').append(parameterPair.option.toString()).append(' ');
            stringBuilder.append(parameterPair.value.toString()).append(' ');
        }
        return stringBuilder.toString();
    }

    public ArrayList<String> serialize() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ParameterPair parameterPair : this.parameters) {
            arrayList.add("-" + parameterPair.option.toString());
            if (parameterPair.value instanceof String) {
                arrayList.add((String)parameterPair.value);
                continue;
            }
            if (parameterPair.value instanceof Class) {
                arrayList.add(((Class)parameterPair.value).getCanonicalName());
                continue;
            }
            arrayList.add(parameterPair.value.toString());
        }
        return arrayList;
    }

    static final class ParameterPair {
        public OptionID option;
        public Object value;

        public ParameterPair(OptionID optionID, Object object) {
            this.option = optionID;
            this.value = object;
        }

        public String toString() {
            return "-" + this.option.getName() + " " + this.value;
        }
    }
}

