/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.AbstractParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.util.ArrayList;
import java.util.List;

public class ChainedParameterization
extends AbstractParameterization {
    private List<Parameterization> chain = new ArrayList<Parameterization>();
    private Parameterization errorTarget = this;

    public ChainedParameterization(Parameterization ... parameterizationArray) {
        for (Parameterization parameterization : parameterizationArray) {
            this.chain.add(parameterization);
        }
    }

    public void appendParameterization(Parameterization parameterization) {
        this.chain.add(parameterization);
    }

    @Override
    public boolean setValueForOption(Parameter<?> parameter) throws ParameterException {
        for (Parameterization parameterization : this.chain) {
            if (!parameterization.setValueForOption(parameter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasUnusedParameters() {
        for (Parameterization parameterization : this.chain) {
            if (!parameterization.hasUnusedParameters()) continue;
            return true;
        }
        return false;
    }

    public void errorsTo(Parameterization parameterization) {
        this.errorTarget = parameterization;
    }

    @Override
    public void reportError(ParameterException parameterException) {
        if (this.equals(this.errorTarget)) {
            super.reportError(parameterException);
        } else {
            this.errorTarget.reportError(parameterException);
        }
    }

    @Override
    public Parameterization descend(Object object) {
        ChainedParameterization chainedParameterization = new ChainedParameterization(new Parameterization[0]);
        chainedParameterization.errorsTo(this.errorTarget);
        for (Parameterization parameterization : this.chain) {
            chainedParameterization.appendParameterization(parameterization.descend(object));
        }
        return chainedParameterization;
    }
}

