/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.histogram;

import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.AbstractStaticHistogram;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.DoubleHistogram;
import java.util.Arrays;

public class DoubleStaticHistogram
extends AbstractStaticHistogram
implements DoubleHistogram {
    double[] data;

    public DoubleStaticHistogram(int n, double d, double d2) {
        super(n, d, d2);
        this.data = (double[])(n >= 0 ? new double[n] : null);
    }

    @Override
    public void increment(double d, double d2) {
        int n = this.getBinNr(d);
        if (n < 0) {
            if (this.size - n > this.data.length) {
                double[] dArray = new double[DoubleStaticHistogram.growSize(this.data.length, this.size - n)];
                System.arraycopy(this.data, 0, dArray, -n, this.size);
                this.data = dArray;
            } else {
                System.arraycopy(this.data, 0, this.data, -n, this.size);
                Arrays.fill(this.data, 0, -n, 0.0);
            }
            this.data[0] = d2;
            assert (this.data.length >= this.size - n);
            this.offset -= n;
            this.size -= n;
        } else if (n >= this.data.length) {
            double[] dArray = new double[DoubleStaticHistogram.growSize(this.data.length, n + 1)];
            System.arraycopy(this.data, 0, dArray, 0, this.size);
            dArray[n] = d2;
            this.data = dArray;
            this.size = n + 1;
            this.max = Double.MAX_VALUE;
        } else {
            if (n >= this.size) {
                this.size = n + 1;
            }
            int n2 = n;
            this.data[n2] = this.data[n2] + d2;
        }
    }

    public double get(double d) {
        int n = this.getBinNr(d);
        if (n < 0 || n >= this.size) {
            return 0.0;
        }
        return this.data[n];
    }

    @Override
    public Iter iter() {
        return new Iter();
    }

    public class Iter
    extends AbstractStaticHistogram.Iter
    implements DoubleHistogram.Iter {
        public Iter() {
            super(DoubleStaticHistogram.this);
        }

        @Override
        public double getValue() {
            return DoubleStaticHistogram.this.data[this.bin];
        }
    }
}

