/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.GZIPInputStream;

public final class FileUtil {
    private FileUtil() {
    }

    public static String getFilenameExtension(File file) {
        return FileUtil.getFilenameExtension(file.getName());
    }

    public static String getFilenameExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n >= string.length() - 1) {
            return null;
        }
        return string.substring(string.lastIndexOf(46) + 1).toLowerCase();
    }

    public static InputStream openSystemFile(String string) throws FileNotFoundException {
        try {
            return new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = string.replace(File.separatorChar, '/');
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(string2);
            if (inputStream == null) {
                throw fileNotFoundException;
            }
            return inputStream;
        }
    }

    public static InputStream tryGzipInput(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 16);
            inputStream = pushbackInputStream;
            byte[] byArray = new byte[]{0, 0};
            pushbackInputStream.read(byArray);
            pushbackInputStream.unread(byArray);
            if (byArray[0] == 31 && byArray[1] == -117) {
                return new GZIPInputStream(pushbackInputStream);
            }
            return inputStream;
        }
        inputStream.mark(16);
        boolean bl = inputStream.read() == 31 && inputStream.read() == -117;
        inputStream.reset();
        if (bl) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public static File locateFile(String string, String string2) {
        File file = new File(string);
        if (file.exists()) {
            return file;
        }
        if (string2 != null && (file = new File(string2, string)).exists()) {
            return file;
        }
        String string3 = string.trim();
        if (!string.equals(string3) && (file = FileUtil.locateFile(string3, string2)) != null) {
            return file;
        }
        string3 = string.replace('/', File.separatorChar);
        if (!string.equals(string3) && (file = FileUtil.locateFile(string3, string2)) != null) {
            return file;
        }
        string3 = string.replace('\\', File.separatorChar);
        if (!string.equals(string3) && (file = FileUtil.locateFile(string3, string2)) != null) {
            return file;
        }
        if (string.length() > 2 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"' && (file = FileUtil.locateFile(string.substring(1, string.length() - 1), string2)) != null) {
            return file;
        }
        return null;
    }

    public static String slurp(InputStream inputStream) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            stringBuilder.append(new String(byArray, 0, n));
        }
        inputStream.close();
        return stringBuilder.toString();
    }
}

