/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceLoader;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceScanner;
import java.lang.reflect.Modifier;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ELKIServiceRegistry {
    private static final Logging LOG = Logging.getLogger(ELKIServiceRegistry.class);
    private static final URLClassLoader CLASSLOADER = (URLClassLoader)ClassLoader.getSystemClassLoader();
    public static final String FACTORY_POSTFIX = "$Factory";
    private static Map<Class<?>, Entry> data = new HashMap();
    static final Class<?> FAILED_LOAD = Entry.class;

    private ELKIServiceRegistry() {
    }

    protected static void register(Class<?> clazz, String string) {
        Entry entry = data.get(clazz);
        if (entry == null) {
            entry = new Entry();
            data.put(clazz, entry);
        }
        entry.addName(string);
    }

    protected static void register(Class<?> clazz, Class<?> clazz2) {
        Entry entry = data.get(clazz);
        if (entry == null) {
            entry = new Entry();
            data.put(clazz, entry);
        }
        String string = clazz2.getCanonicalName();
        entry.addHit(string, clazz2);
        if (clazz2.isAnnotationPresent(Alias.class)) {
            Alias alias = clazz2.getAnnotation(Alias.class);
            for (String string2 : alias.value()) {
                entry.addAlias(string2, string);
            }
        }
    }

    protected static void registerAlias(Class<?> clazz, String string, String string2) {
        Entry entry = data.get(clazz);
        assert (entry != null);
        entry.addAlias(string, string2);
    }

    private static Class<?> tryLoadClass(String string) {
        try {
            return CLASSLOADER.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    protected static boolean contains(Class<?> clazz) {
        return data.containsKey(clazz);
    }

    public static List<Class<?>> findAllImplementations(Class<?> clazz) {
        Entry entry;
        if (clazz == null) {
            return Collections.emptyList();
        }
        if (!ELKIServiceRegistry.contains(clazz)) {
            ELKIServiceLoader.load(clazz);
            ELKIServiceScanner.load(clazz);
        }
        if ((entry = data.get(clazz)) == null) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList(entry.len);
        for (int i = 0; i < entry.len; ++i) {
            Class<?> clazz2 = entry.clazzes[i];
            if (clazz2 == null) {
                clazz2 = ELKIServiceRegistry.tryLoadClass(entry.names[i]);
                if (clazz2 == null) {
                    LOG.warning("Failed to load class " + entry.names[i] + " for interface " + clazz.getName());
                    clazz2 = FAILED_LOAD;
                }
                ((Entry)entry).clazzes[i] = clazz2;
            }
            if (clazz2 == FAILED_LOAD || arrayList.contains(clazz2)) continue;
            arrayList.add(clazz2);
        }
        return arrayList;
    }

    public static List<Class<?>> findAllImplementations(Class<?> clazz, boolean bl, boolean bl2) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        if (!bl && bl2) {
            return ELKIServiceRegistry.findAllImplementations(clazz);
        }
        if (!ELKIServiceRegistry.contains(clazz)) {
            ELKIServiceLoader.load(clazz);
            ELKIServiceScanner.load(clazz);
        }
        List<Class<?>> list = ELKIServiceRegistry.findAllImplementations(clazz);
        HashSet hashSet = new HashSet(list);
        Iterator<Class<?>> iterator = ELKIServiceScanner.nonindexedClasses();
        while (iterator.hasNext()) {
            Class<?> clazz2 = iterator.next();
            if (hashSet.contains(clazz2) || !bl && (Modifier.isInterface(clazz2.getModifiers()) || Modifier.isAbstract(clazz2.getModifiers()) || Modifier.isPrivate(clazz2.getModifiers())) || !clazz.isAssignableFrom(clazz2)) continue;
            if (bl2) {
                boolean bl3 = false;
                try {
                    bl3 = clazz2.getConstructor(new Class[0]) != null;
                }
                catch (Error | Exception throwable) {
                    // empty catch block
                }
                try {
                    bl3 = bl3 || ClassGenericsUtil.getParameterizer(clazz2) != null;
                }
                catch (Error | Exception throwable) {
                    // empty catch block
                }
                if (!bl3) continue;
            }
            list.add(clazz2);
            hashSet.add(clazz2);
        }
        return list;
    }

    public static <C> Class<? extends C> findImplementation(Class<? super C> clazz, String string) {
        Object object;
        if (!ELKIServiceRegistry.contains(clazz)) {
            ELKIServiceLoader.load(clazz);
            ELKIServiceScanner.load(clazz);
        }
        Entry entry = data.get(clazz);
        int n = -1;
        Class<Object> clazz2 = null;
        if (entry != null) {
            for (n = 0; n < entry.len && !entry.names[n].equals(string); ++n) {
            }
            if (n < entry.len) {
                clazz2 = entry.clazzes[n];
            } else {
                n = -1;
            }
        } else if (LOG.isDebuggingFinest()) {
            LOG.debugFinest("Finding implementations for unregistered type: " + clazz.getName() + " " + string);
        }
        if (clazz2 == null) {
            clazz2 = ELKIServiceRegistry.tryLoadClass(string + FACTORY_POSTFIX);
            if (clazz2 == null) {
                clazz2 = ELKIServiceRegistry.tryLoadClass(string);
            }
            if (clazz2 == null && (clazz2 = ELKIServiceRegistry.tryLoadClass(clazz.getPackage().getName() + "." + string + FACTORY_POSTFIX)) == null) {
                clazz2 = ELKIServiceRegistry.tryLoadClass(clazz.getPackage().getName() + "." + string);
            }
        }
        if (clazz2 == null && entry != null && entry.aliaslen > 0) {
            object = clazz.getPackage().getName() + "." + string;
            for (int i = 0; i < entry.aliaslen; i += 2) {
                if (!entry.aliases[i].equalsIgnoreCase(string) && !entry.aliases[i].equalsIgnoreCase((String)object)) continue;
                clazz2 = ELKIServiceRegistry.findImplementation(clazz, entry.aliases[++i]);
                break;
            }
        }
        if (clazz2 == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(clazz2)) {
            LOG.warning("Invalid entry in service file for class " + clazz.getName() + ": " + string);
            clazz2 = FAILED_LOAD;
        }
        if (entry != null) {
            if (n < 0) {
                entry.addHit(string, clazz2);
            } else {
                assert (entry.names[n].equalsIgnoreCase(string));
                ((Entry)entry).clazzes[n] = clazz2;
            }
        }
        if (clazz2 == FAILED_LOAD) {
            return null;
        }
        object = clazz2.asSubclass(clazz);
        return object;
    }

    private static class Entry {
        private static final String[] EMPTY_ALIASES = new String[0];
        private String[] names = new String[3];
        private Class<?>[] clazzes = new Class[3];
        private int len = 0;
        private String[] aliases = EMPTY_ALIASES;
        private int aliaslen = 0;

        private Entry() {
        }

        private void addName(String string) {
            if (this.len == this.names.length) {
                int n = (this.len << 1) + 1;
                this.names = Arrays.copyOf(this.names, n);
                this.clazzes = Arrays.copyOf(this.clazzes, n);
            }
            this.names[this.len++] = string;
        }

        private void addHit(String string, Class<?> clazz) {
            if (this.len == this.names.length) {
                int n = (this.len << 1) + 1;
                this.names = Arrays.copyOf(this.names, n);
                this.clazzes = Arrays.copyOf(this.clazzes, n);
            }
            this.names[this.len] = string;
            this.clazzes[this.len] = clazz;
            ++this.len;
        }

        private void addAlias(String string, String string2) {
            if (this.aliases == EMPTY_ALIASES) {
                this.aliases = new String[6];
            }
            if (this.aliaslen == this.aliases.length) {
                this.aliases = Arrays.copyOf(this.aliases, this.aliaslen << 1);
            }
            this.aliases[this.aliaslen++] = string;
            this.aliases[this.aliaslen++] = string2;
        }
    }
}

