/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities;

import de.lmu.ifi.dbs.elki.utilities.ELKIServiceRegistry;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;

public class ELKIServiceLoader {
    public static final String RESOURCE_PREFIX = "META-INF/elki/";
    public static final String FILENAME_PREFIX = "META-INF" + File.separator + "elki" + File.separator;
    public static final char COMMENT_CHAR = '#';

    private ELKIServiceLoader() {
    }

    public static void load(Class<?> clazz) {
        ELKIServiceLoader.load(clazz, ClassLoader.getSystemClassLoader());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void load(Class<?> clazz, ClassLoader classLoader) {
        try {
            String string = RESOURCE_PREFIX + clazz.getName();
            Enumeration<URL> enumeration = classLoader.getResources(string);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                char[] cArray = new char[16384];
                try {
                    InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream(), "UTF-8");
                    Throwable throwable = null;
                    try {
                        int n = 0;
                        int n2 = 0;
                        int n3 = inputStreamReader.read(cArray, 0, cArray.length);
                        while (n2 < n3) {
                            char c;
                            while (n2 < n3 && (c = cArray[n2]) != '\n' && c != '\r') {
                                ++n2;
                            }
                            if (n2 == n3 && inputStreamReader.ready()) {
                                if (n > 0) {
                                    System.arraycopy(cArray, n, cArray, 0, n3 - n);
                                    n3 -= n;
                                    n2 -= n;
                                    n = 0;
                                } else if (n3 == cArray.length) {
                                    throw new IOException("Buffer size exceeded. Maximum line length in service files is: " + cArray.length + " in file: " + string);
                                }
                                n3 = inputStreamReader.read(cArray, n3, cArray.length - n3);
                                continue;
                            }
                            ELKIServiceLoader.parseLine(clazz, cArray, n, n2, uRL);
                            while (n2 < n3 && ((c = cArray[n2]) == '\n' || c == '\r')) {
                                ++n2;
                            }
                            n = n2;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStreamReader == null) continue;
                        if (throwable != null) {
                            try {
                                inputStreamReader.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStreamReader.close();
                    }
                }
                catch (IOException iOException) {
                    throw new AbortException("Error reading configuration file", iOException);
                    return;
                }
            }
        }
        catch (IOException iOException) {
            throw new AbortException("Could not load service configuration files.", iOException);
        }
    }

    private static void parseLine(Class<?> clazz, char[] cArray, int n, int n2, URL uRL) {
        int n3;
        while (n < n2 && cArray[n] == ' ') {
            ++n;
        }
        if (n >= n2 || cArray[n] == '#') {
            return;
        }
        for (n3 = n + 1; n3 < n2 && cArray[n3] != ' '; ++n3) {
        }
        String string = new String(cArray, n, n3 - n);
        ELKIServiceRegistry.register(clazz, string);
        int n4 = n3 + 1;
        int n5 = -1;
        while (n4 < n2) {
            while (n4 < n2 && cArray[n4] == ' ') {
                ++n4;
            }
            for (n5 = n4 + 1; n5 < n2 && cArray[n5] != ' '; ++n5) {
            }
            if (n4 < n5) {
                ELKIServiceRegistry.registerAlias(clazz, new String(cArray, n4, n5 - n4), string);
            }
            n4 = n5 + 1;
        }
    }
}

