/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.persistent;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Counter;
import de.lmu.ifi.dbs.elki.persistent.Page;
import de.lmu.ifi.dbs.elki.persistent.PageFile;

public abstract class AbstractPageFile<P extends Page>
implements PageFile<P> {
    private Counter readAccess;
    private Counter writeAccess;

    public AbstractPageFile() {
        Logging logging = this.getLogger();
        this.readAccess = logging.isStatistics() ? logging.newCounter(this.getClass().getName() + ".reads") : null;
        this.writeAccess = logging.isStatistics() ? logging.newCounter(this.getClass().getName() + ".writes") : null;
    }

    protected abstract Logging getLogger();

    @Override
    public final synchronized int writePage(P p) {
        int n = this.setPageID(p);
        this.writePage(n, p);
        return n;
    }

    protected abstract void writePage(int var1, P var2);

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void logStatistics() {
        if (this.readAccess != null) {
            this.getLogger().statistics(this.readAccess);
        }
        if (this.writeAccess != null) {
            this.getLogger().statistics(this.writeAccess);
        }
    }

    protected void countRead() {
        if (this.readAccess != null) {
            this.readAccess.increment();
        }
    }

    protected void countWrite() {
        if (this.writeAccess != null) {
            this.writeAccess.increment();
        }
    }
}

