/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.parallel;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.parallel.Executor;
import de.lmu.ifi.dbs.elki.parallel.processor.Processor;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedVariable;
import java.util.HashMap;

public class SingleThreadedExecutor {
    public static final void run(DBIDs dBIDs, Processor ... processorArray) {
        new SingleThreadedRunner(dBIDs, processorArray).run();
    }

    protected static class SingleThreadedRunner
    implements Executor {
        private DBIDs ids;
        private Processor[] procs;
        private HashMap<SharedVariable<?>, SharedVariable.Instance<?>> variables = new HashMap();

        protected SingleThreadedRunner(DBIDs dBIDs, Processor[] processorArray) {
            this.ids = dBIDs;
            this.procs = processorArray;
        }

        public void run() {
            Processor.Instance[] instanceArray = new Processor.Instance[this.procs.length];
            for (int i = 0; i < this.procs.length; ++i) {
                instanceArray[i] = this.procs[i].instantiate(this);
            }
            DBIDIter dBIDIter = this.ids.iter();
            while (dBIDIter.valid()) {
                for (int i = 0; i < instanceArray.length; ++i) {
                    instanceArray[i].map(dBIDIter);
                }
                dBIDIter.advance();
            }
            for (int i = 0; i < instanceArray.length; ++i) {
                this.procs[i].cleanup(instanceArray[i]);
            }
        }

        @Override
        public <I extends SharedVariable.Instance<?>> I getInstance(SharedVariable<I> sharedVariable) {
            SharedVariable.Instance<Object> instance = this.variables.get(sharedVariable);
            if (instance == null) {
                instance = sharedVariable.instantiate();
                this.variables.put(sharedVariable, instance);
            }
            return (I)instance;
        }
    }
}

