/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.parallel;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.parallel.Executor;
import de.lmu.ifi.dbs.elki.parallel.ParallelCore;
import de.lmu.ifi.dbs.elki.parallel.processor.Processor;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class ParallelExecutor {
    public static final void run(DBIDs dBIDs, Processor ... processorArray) {
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(dBIDs);
        ParallelCore parallelCore = ParallelCore.getCore();
        try {
            int n = arrayDBIDs.size();
            parallelCore.connect();
            int n2 = parallelCore.getParallelism();
            n2 = n > n2 * n2 * 16 ? n2 * n2 - 1 : n2;
            int n3 = (n + (n2 - 1)) / n2;
            ArrayList<Future<ArrayDBIDs>> arrayList = new ArrayList<Future<ArrayDBIDs>>(n2);
            for (int i = 0; i < n2; ++i) {
                int n4 = i * n3;
                int n5 = n4 + n3 < n ? n4 + n3 : n;
                BlockArrayRunner blockArrayRunner = new BlockArrayRunner(arrayDBIDs, n4, n5, processorArray);
                arrayList.add(parallelCore.submit(blockArrayRunner));
            }
            for (Future future : arrayList) {
                future.get();
            }
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException("Processor execution failed.", executionException);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Parallel execution interrupted.");
        }
        finally {
            parallelCore.disconnect();
        }
    }

    protected static class BlockArrayRunner
    implements Callable<ArrayDBIDs>,
    Executor {
        private ArrayDBIDs ids;
        private int start;
        private int end;
        private Processor[] procs;
        private HashMap<SharedVariable<?>, SharedVariable.Instance<?>> variables = new HashMap();

        protected BlockArrayRunner(ArrayDBIDs arrayDBIDs, int n, int n2, Processor[] processorArray) {
            this.ids = arrayDBIDs;
            this.start = n;
            this.end = n2;
            this.procs = processorArray;
        }

        @Override
        public ArrayDBIDs call() {
            int n;
            Processor.Instance[] instanceArray = new Processor.Instance[this.procs.length];
            for (int i = 0; i < this.procs.length; ++i) {
                instanceArray[i] = this.procs[i].instantiate(this);
            }
            DBIDArrayIter dBIDArrayIter = this.ids.iter();
            dBIDArrayIter.seek(this.start);
            for (n = this.end - this.start; dBIDArrayIter.valid() && n >= 0; --n) {
                for (int i = 0; i < instanceArray.length; ++i) {
                    instanceArray[i].map(dBIDArrayIter);
                }
                dBIDArrayIter.advance();
            }
            for (n = 0; n < instanceArray.length; ++n) {
                this.procs[n].cleanup(instanceArray[n]);
            }
            return this.ids;
        }

        @Override
        public <I extends SharedVariable.Instance<?>> I getInstance(SharedVariable<I> sharedVariable) {
            SharedVariable.Instance<Object> instance = this.variables.get(sharedVariable);
            if (instance == null) {
                instance = sharedVariable.instantiate();
                this.variables.put(sharedVariable, instance);
            }
            return (I)instance;
        }
    }
}

