/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.tests;

import de.lmu.ifi.dbs.elki.math.statistics.tests.GoodnessOfFitTest;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Arrays;

@Reference(authors="F. W. Scholz, and M. A. Stephens", title="K-sample Anderson\u2013Darling tests", booktitle="Journal of the American Statistical Association, 82(399)", url="http://dx.doi.org/10.1080/01621459.1987.10478517")
public class StandardizedTwoSampleAndersonDarlingTest
implements GoodnessOfFitTest {
    public static final StandardizedTwoSampleAndersonDarlingTest STATIC = new StandardizedTwoSampleAndersonDarlingTest();
    @Reference(authors="D. A. Darling", title="The Kolmogorov-Smirnov, Cramer-von Mises tests", booktitle="Annals of mathematical statistics 28(4)", url="http://dx.doi.org/10.1214/aoms/1177706788")
    public static final Void ADDITIONAL_REFERENCE_1 = null;
    @Reference(authors="A. N. Pettitt", title="A two-sample Anderson-Darling rank statistic", booktitle="Biometrika 63 (1)", url="http://dx.doi.org/10.1093/biomet/63.1.161")
    public static final Void ADDITIONAL_REFERENCE_2 = null;

    @Override
    public double deviation(double[] dArray, double[] dArray2) {
        double d = this.unstandardized(dArray, dArray2);
        int n = dArray.length + dArray2.length;
        double d2 = 1.0 / (double)dArray.length + 1.0 / (double)dArray2.length;
        double d3 = 0.0;
        double d4 = 1.0 / (double)(n - 1);
        for (int i = n - 2; i > 0; --i) {
            d3 += d4 / (double)(n - i);
            d4 += 1.0 / (double)i;
        }
        double d5 = 4.0 * d3 - 6.0 + (10.0 - 6.0 * d3) * d2;
        double d6 = n * n;
        double d7 = d6 * (double)n;
        double d8 = 12.0 * d3 - 22.0 + 8.0 * d4 + (2.0 * d3 - 14.0 * d4 - 4.0) * d2;
        double d9 = 36.0 * d4 + 4.0 + (2.0 * d4 - 6.0) * d2;
        double d10 = (d5 * d7 + d8 * d6 + d9 * (double)n + 24.0) / (((double)n - 1.0) * ((double)n - 2.0) * ((double)n - 3.0));
        return d10 > 0.0 ? (d - 1.0) / Math.sqrt(d10) : 0.0;
    }

    public double deviation(double[][] dArray) {
        int n;
        int n2 = this.totalLength(dArray);
        double d = this.unstandardized(dArray, n2);
        int n3 = dArray.length;
        double d2 = 0.0;
        for (double[] dArray2 : dArray) {
            d2 += 1.0 / (double)dArray2.length;
        }
        double d3 = 0.0;
        double d4 = 1.0 / (double)(n2 - 1);
        for (n = n2 - 2; n > 0; --n) {
            d3 += d4 / (double)(n2 - n);
            d4 += 1.0 / (double)n;
        }
        double d5 = (4.0 * d3 - 6.0) * (double)(n3 - 1) + (10.0 - 6.0 * d3) * d2;
        double d6 = n2 * n2;
        double d7 = d6 * (double)n2;
        n = n3 * n3;
        double d8 = d4 * (double)n3;
        double d9 = (2.0 * d3 - 4.0) * (double)n + 8.0 * d8 + (2.0 * d3 - 14.0 * d4 - 4.0) * d2 - 8.0 * d4 + 4.0 * d3 - 6.0;
        double d10 = (6.0 * d4 + 2.0 * d3 - 2.0) * (double)n + (4.0 * d4 - 4.0 * d3 + 6.0) * (double)n3 + (2.0 * d4 - 6.0) * d2 + 4.0 * d4;
        double d11 = (2.0 * d4 + 6.0) * (double)n - 4.0 * d8;
        double d12 = (d5 * d7 + d9 * d6 + d10 * (double)n2 + d11) / (((double)n2 - 1.0) * ((double)n2 - 2.0) * ((double)n2 - 3.0));
        return d12 > 0.0 ? (d - (double)(n3 - 1)) / Math.sqrt(d12) : 0.0;
    }

    public double unstandardized(double[][] dArray) {
        int n = this.totalLength(dArray);
        return this.unstandardized(dArray, n);
    }

    private double unstandardized(double[][] dArray, int n) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n];
        int n3 = 0;
        for (double[] i : dArray) {
            Arrays.sort(i);
            System.arraycopy(i, 0, dArray2, n3, i.length);
            n3 += i.length;
        }
        assert (n3 == n);
        Arrays.sort(dArray2);
        int[] nArray = new int[n2];
        double[] dArray3 = new double[n2];
        int d = 0;
        while (d < n) {
            double d2 = dArray2[d++];
            int n4 = 1;
            while (d < n && dArray2[d] == d2) {
                ++d;
                ++n4;
            }
            int n5 = 0;
            while (n5 < n2) {
                double[] dArray4 = dArray[n5];
                int n6 = nArray[n5];
                assert (n6 >= dArray4.length || dArray4[n6] >= d2);
                int n7 = 0;
                while (n6 < dArray4.length && dArray4[n6] == d2) {
                    ++n6;
                    ++n7;
                }
                if (n7 > 0) {
                    assert (nArray[n5] + n7 == n6);
                    nArray[n5] = n6;
                }
                double d3 = (double)d - 0.5 * (double)n4;
                double d4 = (double)n * ((double)n6 - 0.5 * (double)n7) - (double)dArray4.length * d3;
                int n8 = n5++;
                dArray3[n8] = dArray3[n8] + (double)n4 * d4 * d4 / (d3 * ((double)n - d3) - 0.25 * (double)n * (double)n4);
            }
        }
        double d5 = 0.0;
        for (int i = 0; i < n2; ++i) {
            d5 += dArray3[i] / (double)dArray[i].length;
        }
        return d5 *= ((double)n - 1.0) / (double)(n * n);
    }

    public double unstandardized(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = n + n2;
        double[] dArray3 = new double[n3];
        Arrays.sort(dArray);
        System.arraycopy(dArray, 0, dArray3, 0, n);
        Arrays.sort(dArray2);
        System.arraycopy(dArray2, 0, dArray3, n, n2);
        Arrays.sort(dArray3);
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        double d2 = 0.0;
        int n6 = 0;
        while (n6 < n3) {
            double d3 = dArray3[n6++];
            int n7 = 1;
            while (n6 < n3 && dArray3[n6] == d3) {
                ++n6;
                ++n7;
            }
            double d4 = (double)n6 - 0.5 * (double)n7;
            assert (n4 >= n || dArray[n4] >= d3);
            int n8 = 0;
            while (n4 < n && dArray[n4] == d3) {
                ++n4;
                ++n8;
            }
            double d5 = (double)n3 * ((double)n4 - 0.5 * (double)n8) - (double)n * d4;
            d += (double)n7 * d5 * d5 / (d4 * ((double)n3 - d4) - 0.25 * (double)n3 * (double)n7);
            assert (n5 >= n2 || dArray2[n5] >= d3);
            n8 = 0;
            while (n5 < n2 && dArray2[n5] == d3) {
                ++n5;
                ++n8;
            }
            d5 = (double)n3 * ((double)n5 - 0.5 * (double)n8) - (double)n2 * d4;
            d2 += (double)n7 * d5 * d5 / (d4 * ((double)n3 - d4) - 0.25 * (double)n3 * (double)n7);
        }
        double d6 = d / (double)n + d2 / (double)n2;
        return d6 *= ((double)n3 - 1.0) / (double)(n3 * n3);
    }

    private int totalLength(double[][] dArray) {
        int n = 0;
        for (double[] dArray2 : dArray) {
            n += dArray2.length;
        }
        return n;
    }
}

