/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality;

import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.AbstractIntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="M. Kratz and S. I. Resnick", title="On Least Squares Estimates of an Exponential Tail Coefficient", booktitle="Statistics & Risk Modeling. Band 14, Heft 4", url="http://dx.doi.org/10.1524/strm.1996.14.4.353")
public class ZipfEstimator
extends AbstractIntrinsicDimensionalityEstimator {
    public static final ZipfEstimator STATIC = new ZipfEstimator();

    @Override
    public <A> double estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter, int n) {
        if (n < 2) {
            throw new ArithmeticException("ID estimates require at least 2 non-zero distances");
        }
        double d = (double)n + 0.6;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d6 = numberArrayAdapter.getDouble(a, i);
            assert (d6 > 0.0);
            double d7 = Math.log(d6);
            double d8 = Math.log(d / ((double)i + 0.6));
            d2 += d8 * d7;
            d3 += d8;
            d4 += d7;
            d5 += d8 * d8;
        }
        double d9 = ((double)n * d2 - d3 * d4) / ((double)n * d5 - d3 * d3);
        return -1.0 / d9;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ZipfEstimator makeInstance() {
            return STATIC;
        }
    }
}

