/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality;

import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.AbstractIntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class PWM2Estimator
extends AbstractIntrinsicDimensionalityEstimator {
    public static final PWM2Estimator STATIC = new PWM2Estimator();

    @Override
    public <A> double estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter, int n) {
        if (n < 2) {
            throw new ArithmeticException("ID estimates require at least 2 non-zero distances");
        }
        if (n == 2) {
            double d = numberArrayAdapter.getDouble(a, 0) / numberArrayAdapter.getDouble(a, 1);
            return d / (1.0 - d);
        }
        if (n == 3) {
            double d = numberArrayAdapter.getDouble(a, 1) * 0.5 / numberArrayAdapter.getDouble(a, 2);
            return d / (1.0 - 2.0 * d);
        }
        int n2 = n - 1;
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            d += numberArrayAdapter.getDouble(a, i) * (double)(i + 2) * (double)(i + 1);
        }
        double d2 = numberArrayAdapter.getDouble(a, n2);
        return (d /= (double)(n2 + 2) * d2 * (double)(n2 + 1) * (double)n2) / (1.0 - 3.0 * d);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected PWM2Estimator makeInstance() {
            return STATIC;
        }
    }
}

