/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.WaldDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class WaldMLEstimator
implements DistributionEstimator<WaldDistribution> {
    public static final WaldMLEstimator STATIC = new WaldMLEstimator();

    @Override
    public <A> WaldDistribution estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        int n = numberArrayAdapter.size(a);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = numberArrayAdapter.getDouble(a, i);
            d += d2;
        }
        double d3 = 1.0 / (d /= (double)n);
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d5 = numberArrayAdapter.getDouble(a, i);
            if (!(d5 > 0.0)) continue;
            d4 += 1.0 / d5 - d3;
        }
        return new WaldDistribution(d, (double)n / d4);
    }

    @Override
    public Class<? super WaldDistribution> getDistributionClass() {
        return WaldDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected WaldMLEstimator makeInstance() {
            return STATIC;
        }
    }
}

