/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.UniformDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class UniformMinMaxEstimator
implements DistributionEstimator<UniformDistribution> {
    public static final UniformMinMaxEstimator STATIC = new UniformMinMaxEstimator();

    private UniformMinMaxEstimator() {
    }

    @Override
    public <A> UniformDistribution estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        int n = numberArrayAdapter.size(a);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        for (int i = 0; i < n; ++i) {
            double d = numberArrayAdapter.getDouble(a, i);
            if (!(d > Double.NEGATIVE_INFINITY) || !(d < Double.POSITIVE_INFINITY)) continue;
            doubleMinMax.put(d);
        }
        return this.estimate(doubleMinMax);
    }

    public UniformDistribution estimate(DoubleMinMax doubleMinMax) {
        return new UniformDistribution(Math.max(doubleMinMax.getMin(), -1.7976931348623157E308), Math.min(doubleMinMax.getMax(), Double.MAX_VALUE));
    }

    public Distribution estimate(double d, double d2) {
        return new UniformDistribution(d, d2);
    }

    @Override
    public Class<? super UniformDistribution> getDistributionClass() {
        return UniformDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected UniformMinMaxEstimator makeInstance() {
            return STATIC;
        }
    }
}

